/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.filters;

import com.logviewer.data2.LogFilterContext;
import com.logviewer.data2.LogRecord;
import com.logviewer.filters.RecordPredicate;
import java.util.regex.Pattern;

public class ExceptionOnlyPredicate
implements RecordPredicate {
    private static final Pattern EXCEPTION_PATTERN = Pattern.compile("^\\tat (?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.(?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*|<\\w+>)\\(.+\\)", 8);

    @Override
    public boolean test(LogRecord record, LogFilterContext ctx) {
        if (!record.getMessage().contains("\tat ")) {
            return false;
        }
        return EXCEPTION_PATTERN.matcher(record.getMessage()).find();
    }
}

