/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.data2.net;

import com.logviewer.data2.net.server.Message;
import com.logviewer.utils.MessageReader;
import com.logviewer.utils.OpenByteArrayOutputStream;
import com.logviewer.utils.RuntimeInterruptedException;
import com.logviewer.utils.Utils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnection
implements AutoCloseable {
    private static final int OUTCOME_BUFFER_SIZE = 0x100000;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractConnection.class);
    private final AsynchronousSocketChannel socket;
    private final MessageReader messageReader = new MessageReader();
    private OpenByteArrayOutputStream outcomeMsgQueue;
    protected boolean closed;

    public AbstractConnection(AsynchronousSocketChannel socket) {
        this.socket = socket;
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        Utils.closeQuietly(this.socket);
        this.onDisconnect();
    }

    public synchronized boolean isOpen() {
        return !this.closed && this.socket.isOpen();
    }

    protected abstract void handleMessage(Object var1);

    protected synchronized void sendMessage(Message message) {
        block7: {
            WriteCompletionHandler handler = new WriteCompletionHandler();
            try {
                block6: {
                    while (true) {
                        if (this.closed) {
                            return;
                        }
                        if (this.outcomeMsgQueue == null) break block6;
                        if (this.outcomeMsgQueue.size() < 0x100000) break;
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeInterruptedException(e);
                        }
                    }
                    MessageReader.serializeMessages(this.outcomeMsgQueue, message);
                    break block7;
                }
                OpenByteArrayOutputStream buff = new OpenByteArrayOutputStream();
                MessageReader.serializeMessages(buff, message);
                this.outcomeMsgQueue = new OpenByteArrayOutputStream();
                ByteBuffer byteBuffer = ByteBuffer.wrap(buff.getBuffer(), 0, buff.size());
                this.socket.write(byteBuffer, byteBuffer, handler);
            }
            catch (IOException e) {
                handler.failed((Throwable)e, ByteBuffer.allocate(0));
            }
        }
    }

    protected void onDisconnect() {
    }

    public void init() {
        this.socket.read(this.messageReader.getCurrentBuffer(), null, new CompletionHandler<Integer, Object>(){

            @Override
            public void completed(Integer result, Object attachment) {
                assert (result != 0);
                if (result == -1) {
                    AbstractConnection.this.close();
                    return;
                }
                try {
                    Object msg = AbstractConnection.this.messageReader.onReceive();
                    if (msg != null) {
                        AbstractConnection.this.handleMessage(msg);
                    }
                    AbstractConnection.this.socket.read(AbstractConnection.this.messageReader.getCurrentBuffer(), null, this);
                }
                catch (Throwable e) {
                    LOG.error("Failed to read message", e);
                    AbstractConnection.this.close();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void failed(Throwable exc, Object attachment) {
                AbstractConnection abstractConnection = AbstractConnection.this;
                synchronized (abstractConnection) {
                    if (AbstractConnection.this.closed) {
                        return;
                    }
                    LOG.error("Disconnected", exc);
                    AbstractConnection.this.close();
                }
            }
        });
    }

    private class WriteCompletionHandler
    implements CompletionHandler<Integer, ByteBuffer> {
        private WriteCompletionHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void completed(Integer result, ByteBuffer attachment) {
            if (attachment.hasRemaining()) {
                AbstractConnection.this.socket.write(attachment, attachment, this);
                return;
            }
            AbstractConnection abstractConnection = AbstractConnection.this;
            synchronized (abstractConnection) {
                AbstractConnection.this.notifyAll();
                if (AbstractConnection.this.closed) {
                    return;
                }
                try {
                    if (AbstractConnection.this.outcomeMsgQueue.size() == 0) {
                        AbstractConnection.this.outcomeMsgQueue = null;
                    } else {
                        ByteBuffer bb = ByteBuffer.wrap(AbstractConnection.this.outcomeMsgQueue.getBuffer(), 0, AbstractConnection.this.outcomeMsgQueue.size());
                        AbstractConnection.this.outcomeMsgQueue = new OpenByteArrayOutputStream();
                        AbstractConnection.this.socket.write(bb, bb, this);
                    }
                }
                catch (Throwable e) {
                    LOG.error("Failed to send message", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failed(Throwable exc, ByteBuffer attachment) {
            AbstractConnection abstractConnection = AbstractConnection.this;
            synchronized (abstractConnection) {
                if (AbstractConnection.this.closed) {
                    return;
                }
                LOG.error("Failed to send message", exc);
                AbstractConnection.this.close();
            }
        }
    }
}

