/*
 * Decompiled with CFR 0.152.
 */
package com.logviewer.data2;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import org.springframework.lang.Nullable;

public class FileAttributes
implements Serializable {
    private final long size;
    private final long modifiedTime;

    public FileAttributes(long size, long modifiedTime) {
        this.size = size;
        this.modifiedTime = modifiedTime;
    }

    public FileAttributes(BasicFileAttributes attrs) {
        this(attrs.size(), attrs.lastModifiedTime().toMillis());
    }

    public long getSize() {
        return this.size;
    }

    public long getModifiedTime() {
        return this.modifiedTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FileAttributes)) {
            return false;
        }
        FileAttributes that = (FileAttributes)o;
        return this.size == that.getSize() && this.modifiedTime == that.getModifiedTime();
    }

    public int hashCode() {
        return (int)(this.size * 31L + this.modifiedTime);
    }

    public String toString() {
        return "{size=" + this.size + ", time=" + new Date(this.modifiedTime) + '}';
    }

    @Nullable
    public static FileAttributes fromPath(Path file) throws IOException {
        try {
            return new FileAttributes(Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]));
        }
        catch (NoSuchFileException e) {
            return null;
        }
    }
}

