/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.slimvalidator.validators;

import io.github.sashirestela.slimvalidator.ConstraintValidator;
import io.github.sashirestela.slimvalidator.constraints.Range;
import io.github.sashirestela.slimvalidator.exception.ValidationException;
import java.text.DecimalFormat;

public class RangeValidator
implements ConstraintValidator<Range, Object> {
    private double min;
    private double max;

    @Override
    public void initialize(Range annotation) {
        this.min = annotation.min();
        this.max = annotation.max();
        if (this.min >= this.max) {
            throw new ValidationException("In Range constraint, min must be less than max.");
        }
    }

    @Override
    public String getMessage() {
        DecimalFormat decFormat = new DecimalFormat("#.##");
        decFormat.setDecimalSeparatorAlwaysShown(false);
        StringBuilder message = new StringBuilder();
        message.append("must be");
        if (this.min < Double.MAX_VALUE) {
            message.append(" at least ").append(decFormat.format(this.min));
        }
        if (this.max < Double.MAX_VALUE) {
            message.append(" at most ").append(decFormat.format(this.max));
        }
        message.append(".");
        return message.toString();
    }

    @Override
    public boolean isValid(Object value) {
        if (value == null) {
            return true;
        }
        double number = this.getNumber(value);
        return number >= this.min && number <= this.max;
    }

    private double getNumber(Object value) {
        if (value instanceof Integer) {
            return ((Integer)value).doubleValue();
        }
        if (value instanceof Long) {
            return ((Long)value).doubleValue();
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        throw new ValidationException("Cannot get a number from {0}.", value.getClass().getName(), null);
    }
}

