/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.slimvalidator.validators;

import io.github.sashirestela.slimvalidator.ConstraintValidator;
import io.github.sashirestela.slimvalidator.constraints.ObjectType;
import java.util.Collection;

public class ObjectTypeValidator
implements ConstraintValidator<ObjectType, Object> {
    private Class<?> baseClass;
    private boolean firstGroup;
    private boolean secondGroup;
    private int maxSize;

    @Override
    public void initialize(ObjectType annotation) {
        this.baseClass = annotation.baseClass();
        this.firstGroup = annotation.firstGroup();
        this.secondGroup = annotation.secondGroup();
        this.maxSize = annotation.maxSize();
    }

    @Override
    public boolean isValid(Object value) {
        if (value == null) {
            return true;
        }
        if (!this.firstGroup) {
            return this.baseClass.isInstance(value);
        }
        if (!this.secondGroup) {
            return value instanceof Collection && this.baseClass.isInstance(((Collection)value).iterator().next()) && (this.maxSize == 0 || ((Collection)value).size() <= this.maxSize);
        }
        return value instanceof Collection && ((Collection)value).iterator().next() instanceof Collection && this.baseClass.isInstance(((Collection)((Collection)value).iterator().next()).iterator().next()) && (this.maxSize == 0 || ((Collection)value).size() <= this.maxSize);
    }
}

