/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.assistant;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.common.ResponseFormat;
import io.github.sashirestela.openai.common.tool.Tool;
import io.github.sashirestela.openai.common.tool.ToolChoice;
import io.github.sashirestela.openai.common.tool.ToolChoiceOption;
import io.github.sashirestela.openai.domain.assistant.ThreadRequest;
import io.github.sashirestela.openai.domain.assistant.ToolResource;
import io.github.sashirestela.openai.domain.assistant.TruncationStrategy;
import io.github.sashirestela.slimvalidator.constraints.ObjectType;
import io.github.sashirestela.slimvalidator.constraints.Range;
import io.github.sashirestela.slimvalidator.constraints.Required;
import io.github.sashirestela.slimvalidator.constraints.Size;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class ThreadCreateAndRunRequest {
    @Required
    private String assistantId;
    private ThreadRequest thread;
    private String model;
    private String instructions;
    @Size(max=20)
    private List<Tool> tools;
    private ToolResource toolResources;
    @Size(max=16)
    private Map<String, String> metadata;
    @Range(min=0.0, max=2.0)
    private Double temperature;
    @Range(min=0.0, max=1.0)
    private Double topP;
    private Boolean stream;
    @Range(min=256.0)
    private Integer maxPromptTokens;
    @Range(min=256.0)
    private Integer maxCompletionTokens;
    private TruncationStrategy truncationStrategy;
    @ObjectType.List(value={@ObjectType(baseClass=ToolChoiceOption.class), @ObjectType(baseClass=ToolChoice.class)})
    private Object toolChoice;
    private Boolean parallelToolCalls;
    @ObjectType.List(value={@ObjectType(baseClass=String.class), @ObjectType(baseClass=ResponseFormat.class)})
    private Object responseFormat;

    ThreadCreateAndRunRequest(String assistantId, ThreadRequest thread, String model, String instructions, List<Tool> tools, ToolResource toolResources, Map<String, String> metadata, Double temperature, Double topP, Boolean stream, Integer maxPromptTokens, Integer maxCompletionTokens, TruncationStrategy truncationStrategy, Object toolChoice, Boolean parallelToolCalls, Object responseFormat) {
        this.assistantId = assistantId;
        this.thread = thread;
        this.model = model;
        this.instructions = instructions;
        this.tools = tools;
        this.toolResources = toolResources;
        this.metadata = metadata;
        this.temperature = temperature;
        this.topP = topP;
        this.stream = stream;
        this.maxPromptTokens = maxPromptTokens;
        this.maxCompletionTokens = maxCompletionTokens;
        this.truncationStrategy = truncationStrategy;
        this.toolChoice = toolChoice;
        this.parallelToolCalls = parallelToolCalls;
        this.responseFormat = responseFormat;
    }

    public static ThreadCreateAndRunRequestBuilder builder() {
        return new ThreadCreateAndRunRequestBuilder();
    }

    public String getAssistantId() {
        return this.assistantId;
    }

    public ThreadRequest getThread() {
        return this.thread;
    }

    public String getModel() {
        return this.model;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public List<Tool> getTools() {
        return this.tools;
    }

    public ToolResource getToolResources() {
        return this.toolResources;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public Integer getMaxPromptTokens() {
        return this.maxPromptTokens;
    }

    public Integer getMaxCompletionTokens() {
        return this.maxCompletionTokens;
    }

    public TruncationStrategy getTruncationStrategy() {
        return this.truncationStrategy;
    }

    public Object getToolChoice() {
        return this.toolChoice;
    }

    public Boolean getParallelToolCalls() {
        return this.parallelToolCalls;
    }

    public Object getResponseFormat() {
        return this.responseFormat;
    }

    public ThreadCreateAndRunRequest withStream(Boolean stream) {
        return this.stream == stream ? this : new ThreadCreateAndRunRequest(this.assistantId, this.thread, this.model, this.instructions, this.tools, this.toolResources, this.metadata, this.temperature, this.topP, stream, this.maxPromptTokens, this.maxCompletionTokens, this.truncationStrategy, this.toolChoice, this.parallelToolCalls, this.responseFormat);
    }

    public static class ThreadCreateAndRunRequestBuilder {
        private String assistantId;
        private ThreadRequest thread;
        private String model;
        private String instructions;
        private ArrayList<Tool> tools;
        private ToolResource toolResources;
        private Map<String, String> metadata;
        private Double temperature;
        private Double topP;
        private Boolean stream;
        private Integer maxPromptTokens;
        private Integer maxCompletionTokens;
        private TruncationStrategy truncationStrategy;
        private Object toolChoice;
        private Boolean parallelToolCalls;
        private Object responseFormat;

        ThreadCreateAndRunRequestBuilder() {
        }

        public ThreadCreateAndRunRequestBuilder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public ThreadCreateAndRunRequestBuilder thread(ThreadRequest thread) {
            this.thread = thread;
            return this;
        }

        public ThreadCreateAndRunRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        public ThreadCreateAndRunRequestBuilder instructions(String instructions) {
            this.instructions = instructions;
            return this;
        }

        public ThreadCreateAndRunRequestBuilder tool(Tool tool) {
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.add(tool);
            return this;
        }

        public ThreadCreateAndRunRequestBuilder tools(Collection<? extends Tool> tools) {
            if (tools == null) {
                throw new NullPointerException("tools cannot be null");
            }
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.addAll(tools);
            return this;
        }

        public ThreadCreateAndRunRequestBuilder clearTools() {
            if (this.tools != null) {
                this.tools.clear();
            }
            return this;
        }

        public ThreadCreateAndRunRequestBuilder toolResources(ToolResource toolResources) {
            this.toolResources = toolResources;
            return this;
        }

        public ThreadCreateAndRunRequestBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public ThreadCreateAndRunRequestBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public ThreadCreateAndRunRequestBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public ThreadCreateAndRunRequestBuilder stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        public ThreadCreateAndRunRequestBuilder maxPromptTokens(Integer maxPromptTokens) {
            this.maxPromptTokens = maxPromptTokens;
            return this;
        }

        public ThreadCreateAndRunRequestBuilder maxCompletionTokens(Integer maxCompletionTokens) {
            this.maxCompletionTokens = maxCompletionTokens;
            return this;
        }

        public ThreadCreateAndRunRequestBuilder truncationStrategy(TruncationStrategy truncationStrategy) {
            this.truncationStrategy = truncationStrategy;
            return this;
        }

        public ThreadCreateAndRunRequestBuilder toolChoice(Object toolChoice) {
            this.toolChoice = toolChoice;
            return this;
        }

        public ThreadCreateAndRunRequestBuilder parallelToolCalls(Boolean parallelToolCalls) {
            this.parallelToolCalls = parallelToolCalls;
            return this;
        }

        public ThreadCreateAndRunRequestBuilder responseFormat(Object responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public ThreadCreateAndRunRequest build() {
            List<Tool> tools;
            switch (this.tools == null ? 0 : this.tools.size()) {
                case 0: {
                    tools = Collections.emptyList();
                    break;
                }
                case 1: {
                    tools = Collections.singletonList(this.tools.get(0));
                    break;
                }
                default: {
                    tools = Collections.unmodifiableList(new ArrayList<Tool>(this.tools));
                }
            }
            return new ThreadCreateAndRunRequest(this.assistantId, this.thread, this.model, this.instructions, tools, this.toolResources, this.metadata, this.temperature, this.topP, this.stream, this.maxPromptTokens, this.maxCompletionTokens, this.truncationStrategy, this.toolChoice, this.parallelToolCalls, this.responseFormat);
        }

        public String toString() {
            return "ThreadCreateAndRunRequest.ThreadCreateAndRunRequestBuilder(assistantId=" + this.assistantId + ", thread=" + this.thread + ", model=" + this.model + ", instructions=" + this.instructions + ", tools=" + this.tools + ", toolResources=" + this.toolResources + ", metadata=" + this.metadata + ", temperature=" + this.temperature + ", topP=" + this.topP + ", stream=" + this.stream + ", maxPromptTokens=" + this.maxPromptTokens + ", maxCompletionTokens=" + this.maxCompletionTokens + ", truncationStrategy=" + this.truncationStrategy + ", toolChoice=" + this.toolChoice + ", parallelToolCalls=" + this.parallelToolCalls + ", responseFormat=" + this.responseFormat + ")";
        }
    }
}

