/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.common.content;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=FileCitationAnnotation.class, name="file_citation"), @JsonSubTypes.Type(value=FilePathAnnotation.class, name="file_path")})
public class FileAnnotation {
    protected Integer index;
    protected AnnotationType type;
    protected String text;
    protected Integer startIndex;
    protected Integer endIndex;

    public Integer getIndex() {
        return this.index;
    }

    public AnnotationType getType() {
        return this.type;
    }

    public String getText() {
        return this.text;
    }

    public Integer getStartIndex() {
        return this.startIndex;
    }

    public Integer getEndIndex() {
        return this.endIndex;
    }

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class FilePathAnnotation
    extends FileAnnotation {
        private FilePath filePath;

        public FilePath getFilePath() {
            return this.filePath;
        }

        public String toString() {
            return "FileAnnotation.FilePathAnnotation(filePath=" + this.getFilePath() + ")";
        }

        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class FilePath {
            private String fileId;

            public String getFileId() {
                return this.fileId;
            }

            public String toString() {
                return "FileAnnotation.FilePathAnnotation.FilePath(fileId=" + this.getFileId() + ")";
            }
        }
    }

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class FileCitationAnnotation
    extends FileAnnotation {
        private FileCitation fileCitation;

        public FileCitation getFileCitation() {
            return this.fileCitation;
        }

        public String toString() {
            return "FileAnnotation.FileCitationAnnotation(fileCitation=" + this.getFileCitation() + ")";
        }

        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class FileCitation {
            private String fileId;
            private String quote;

            public String getFileId() {
                return this.fileId;
            }

            public String getQuote() {
                return this.quote;
            }

            public String toString() {
                return "FileAnnotation.FileCitationAnnotation.FileCitation(fileId=" + this.getFileId() + ", quote=" + this.getQuote() + ")";
            }
        }
    }

    public static enum AnnotationType {
        FILE_CITATION,
        FILE_PATH;

    }
}

