/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.completion;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.common.Usage;
import java.util.List;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class Completion {
    @JsonIgnore
    private String warning;
    private String id;
    private String object;
    private Long created;
    private String model;
    private List<Choice> choices;
    private Usage usage;
    private String systemFingerprint;

    public String firstText() {
        return this.getChoices().get(0).getText();
    }

    public String getWarning() {
        return this.warning;
    }

    public String getId() {
        return this.id;
    }

    public String getObject() {
        return this.object;
    }

    public Long getCreated() {
        return this.created;
    }

    public String getModel() {
        return this.model;
    }

    public List<Choice> getChoices() {
        return this.choices;
    }

    public Usage getUsage() {
        return this.usage;
    }

    public String getSystemFingerprint() {
        return this.systemFingerprint;
    }

    public String toString() {
        return "Completion(warning=" + this.getWarning() + ", id=" + this.getId() + ", object=" + this.getObject() + ", created=" + this.getCreated() + ", model=" + this.getModel() + ", choices=" + this.getChoices() + ", usage=" + this.getUsage() + ", systemFingerprint=" + this.getSystemFingerprint() + ")";
    }

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class Choice {
        private String finishReason;
        private Integer index;
        private LogProbs logprobs;
        private String text;

        public String getFinishReason() {
            return this.finishReason;
        }

        public Integer getIndex() {
            return this.index;
        }

        public LogProbs getLogprobs() {
            return this.logprobs;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return "Completion.Choice(finishReason=" + this.getFinishReason() + ", index=" + this.getIndex() + ", logprobs=" + this.getLogprobs() + ", text=" + this.getText() + ")";
        }

        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class LogProbs {
            private List<Integer> textOffset;
            private List<Double> tokenLogprobs;
            private List<String> tokens;
            private List<List<Double>> topLogprobs;

            public List<Integer> getTextOffset() {
                return this.textOffset;
            }

            public List<Double> getTokenLogprobs() {
                return this.tokenLogprobs;
            }

            public List<String> getTokens() {
                return this.tokens;
            }

            public List<List<Double>> getTopLogprobs() {
                return this.topLogprobs;
            }

            public String toString() {
                return "Completion.Choice.LogProbs(textOffset=" + this.getTextOffset() + ", tokenLogprobs=" + this.getTokenLogprobs() + ", tokens=" + this.getTokens() + ", topLogprobs=" + this.getTopLogprobs() + ")";
            }
        }
    }
}

