/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.assistant;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.domain.assistant.ChunkingStrategy;
import io.github.sashirestela.openai.domain.assistant.ExpiresAfter;
import io.github.sashirestela.slimvalidator.constraints.Size;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class VectorStoreRequest {
    @Size(max=500)
    private List<String> fileIds;
    private String name;
    private ExpiresAfter expiresAfter;
    private ChunkingStrategy chunkingStrategy;
    @Size(max=16)
    private Map<String, String> metadata;

    VectorStoreRequest(List<String> fileIds, String name, ExpiresAfter expiresAfter, ChunkingStrategy chunkingStrategy, Map<String, String> metadata) {
        this.fileIds = fileIds;
        this.name = name;
        this.expiresAfter = expiresAfter;
        this.chunkingStrategy = chunkingStrategy;
        this.metadata = metadata;
    }

    public static VectorStoreRequestBuilder builder() {
        return new VectorStoreRequestBuilder();
    }

    public List<String> getFileIds() {
        return this.fileIds;
    }

    public String getName() {
        return this.name;
    }

    public ExpiresAfter getExpiresAfter() {
        return this.expiresAfter;
    }

    public ChunkingStrategy getChunkingStrategy() {
        return this.chunkingStrategy;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class VectorStoreRequestBuilder {
        private ArrayList<String> fileIds;
        private String name;
        private ExpiresAfter expiresAfter;
        private ChunkingStrategy chunkingStrategy;
        private Map<String, String> metadata;

        VectorStoreRequestBuilder() {
        }

        public VectorStoreRequestBuilder fileId(String fileId) {
            if (this.fileIds == null) {
                this.fileIds = new ArrayList();
            }
            this.fileIds.add(fileId);
            return this;
        }

        public VectorStoreRequestBuilder fileIds(Collection<? extends String> fileIds) {
            if (fileIds == null) {
                throw new NullPointerException("fileIds cannot be null");
            }
            if (this.fileIds == null) {
                this.fileIds = new ArrayList();
            }
            this.fileIds.addAll(fileIds);
            return this;
        }

        public VectorStoreRequestBuilder clearFileIds() {
            if (this.fileIds != null) {
                this.fileIds.clear();
            }
            return this;
        }

        public VectorStoreRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public VectorStoreRequestBuilder expiresAfter(ExpiresAfter expiresAfter) {
            this.expiresAfter = expiresAfter;
            return this;
        }

        public VectorStoreRequestBuilder chunkingStrategy(ChunkingStrategy chunkingStrategy) {
            this.chunkingStrategy = chunkingStrategy;
            return this;
        }

        public VectorStoreRequestBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public VectorStoreRequest build() {
            List<String> fileIds;
            switch (this.fileIds == null ? 0 : this.fileIds.size()) {
                case 0: {
                    fileIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    fileIds = Collections.singletonList(this.fileIds.get(0));
                    break;
                }
                default: {
                    fileIds = Collections.unmodifiableList(new ArrayList<String>(this.fileIds));
                }
            }
            return new VectorStoreRequest(fileIds, this.name, this.expiresAfter, this.chunkingStrategy, this.metadata);
        }

        public String toString() {
            return "VectorStoreRequest.VectorStoreRequestBuilder(fileIds=" + this.fileIds + ", name=" + this.name + ", expiresAfter=" + this.expiresAfter + ", chunkingStrategy=" + this.chunkingStrategy + ", metadata=" + this.metadata + ")";
        }
    }
}

