/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.support;

import io.github.sashirestela.openai.exception.PollingAbortedException;
import java.time.Duration;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import lombok.Generated;
import lombok.NonNull;

public class Poller<T> {
    @NonNull
    private Duration interval;
    @NonNull
    private UnaryOperator<T> pollFunction;
    @NonNull
    private Predicate<T> continueIf;
    private Predicate<T> abortIf;

    public T execute(T startValue) {
        Object object = startValue;
        do {
            try {
                Thread.sleep(this.interval.toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (this.abortIf == null || !this.abortIf.test(object)) continue;
            throw new PollingAbortedException("Polling aborted due to abort condition.");
        } while (this.continueIf.test(object = this.pollFunction.apply(object)));
        return object;
    }

    @Generated
    Poller(@NonNull Duration interval, @NonNull UnaryOperator<T> pollFunction, @NonNull Predicate<T> continueIf, Predicate<T> abortIf) {
        if (interval == null) {
            throw new NullPointerException("interval is marked non-null but is null");
        }
        if (pollFunction == null) {
            throw new NullPointerException("pollFunction is marked non-null but is null");
        }
        if (continueIf == null) {
            throw new NullPointerException("continueIf is marked non-null but is null");
        }
        this.interval = interval;
        this.pollFunction = pollFunction;
        this.continueIf = continueIf;
        this.abortIf = abortIf;
    }

    @Generated
    public static <T> PollerBuilder<T> builder() {
        return new PollerBuilder();
    }

    @NonNull
    @Generated
    public Duration getInterval() {
        return this.interval;
    }

    @NonNull
    @Generated
    public UnaryOperator<T> getPollFunction() {
        return this.pollFunction;
    }

    @NonNull
    @Generated
    public Predicate<T> getContinueIf() {
        return this.continueIf;
    }

    @Generated
    public Predicate<T> getAbortIf() {
        return this.abortIf;
    }

    @Generated
    public static class PollerBuilder<T> {
        @Generated
        private Duration interval;
        @Generated
        private UnaryOperator<T> pollFunction;
        @Generated
        private Predicate<T> continueIf;
        @Generated
        private Predicate<T> abortIf;

        @Generated
        PollerBuilder() {
        }

        @Generated
        public PollerBuilder<T> interval(@NonNull Duration interval) {
            if (interval == null) {
                throw new NullPointerException("interval is marked non-null but is null");
            }
            this.interval = interval;
            return this;
        }

        @Generated
        public PollerBuilder<T> pollFunction(@NonNull UnaryOperator<T> pollFunction) {
            if (pollFunction == null) {
                throw new NullPointerException("pollFunction is marked non-null but is null");
            }
            this.pollFunction = pollFunction;
            return this;
        }

        @Generated
        public PollerBuilder<T> continueIf(@NonNull Predicate<T> continueIf) {
            if (continueIf == null) {
                throw new NullPointerException("continueIf is marked non-null but is null");
            }
            this.continueIf = continueIf;
            return this;
        }

        @Generated
        public PollerBuilder<T> abortIf(Predicate<T> abortIf) {
            this.abortIf = abortIf;
            return this;
        }

        @Generated
        public Poller<T> build() {
            return new Poller<T>(this.interval, this.pollFunction, this.continueIf, this.abortIf);
        }

        @Generated
        public String toString() {
            return "Poller.PollerBuilder(interval=" + String.valueOf(this.interval) + ", pollFunction=" + String.valueOf(this.pollFunction) + ", continueIf=" + String.valueOf(this.continueIf) + ", abortIf=" + String.valueOf(this.abortIf) + ")";
        }
    }
}

