/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.support.DefaultSchemaConverter;
import io.github.sashirestela.slimvalidator.constraints.Required;
import io.github.sashirestela.slimvalidator.constraints.Size;
import lombok.Generated;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class ResponseFormat {
    public static final ResponseFormat TEXT = new ResponseFormat(ResponseFormatType.TEXT, null);
    public static final ResponseFormat JSON_OBJECT = new ResponseFormat(ResponseFormatType.JSON_OBJECT, null);
    private ResponseFormatType type;
    private JsonSchema jsonSchema;

    public static ResponseFormat jsonSchema(JsonSchema jsonSchema) {
        return new ResponseFormat(ResponseFormatType.JSON_SCHEMA, jsonSchema);
    }

    @Generated
    private ResponseFormat(ResponseFormatType type, JsonSchema jsonSchema) {
        this.type = type;
        this.jsonSchema = jsonSchema;
    }

    @Generated
    public ResponseFormat() {
    }

    @Generated
    public ResponseFormatType getType() {
        return this.type;
    }

    @Generated
    public JsonSchema getJsonSchema() {
        return this.jsonSchema;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class JsonSchema {
        private String description;
        @Required
        @Size(max=64)
        private String name;
        private JsonNode schema;
        private Boolean strict;

        public JsonSchema(String description, @NonNull String name, Boolean strict, Class<?> schemaClass, JsonNode schema) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.description = description;
            this.name = name;
            this.strict = strict;
            this.schema = schema != null ? schema : (schemaClass != null ? new DefaultSchemaConverter(Boolean.TRUE).convert(schemaClass) : null);
        }

        @Generated
        public static JsonSchemaBuilder builder() {
            return new JsonSchemaBuilder();
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public JsonNode getSchema() {
            return this.schema;
        }

        @Generated
        public Boolean getStrict() {
            return this.strict;
        }

        @Generated
        public static class JsonSchemaBuilder {
            @Generated
            private String description;
            @Generated
            private String name;
            @Generated
            private Boolean strict;
            @Generated
            private Class<?> schemaClass;
            @Generated
            private JsonNode schema;

            @Generated
            JsonSchemaBuilder() {
            }

            @Generated
            public JsonSchemaBuilder description(String description) {
                this.description = description;
                return this;
            }

            @Generated
            public JsonSchemaBuilder name(@NonNull String name) {
                if (name == null) {
                    throw new NullPointerException("name is marked non-null but is null");
                }
                this.name = name;
                return this;
            }

            @Generated
            public JsonSchemaBuilder strict(Boolean strict) {
                this.strict = strict;
                return this;
            }

            @Generated
            public JsonSchemaBuilder schemaClass(Class<?> schemaClass) {
                this.schemaClass = schemaClass;
                return this;
            }

            @Generated
            public JsonSchemaBuilder schema(JsonNode schema) {
                this.schema = schema;
                return this;
            }

            @Generated
            public JsonSchema build() {
                return new JsonSchema(this.description, this.name, this.strict, this.schemaClass, this.schema);
            }

            @Generated
            public String toString() {
                return "ResponseFormat.JsonSchema.JsonSchemaBuilder(description=" + this.description + ", name=" + this.name + ", strict=" + this.strict + ", schemaClass=" + String.valueOf(this.schemaClass) + ", schema=" + String.valueOf(this.schema) + ")";
            }
        }
    }

    public static enum ResponseFormatType {
        TEXT,
        JSON_OBJECT,
        JSON_SCHEMA;

    }
}

