/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.sashirestela.cleverclient.client.HttpClientAdapter;
import io.github.sashirestela.cleverclient.http.HttpRequestData;
import io.github.sashirestela.cleverclient.retry.RetryConfig;
import io.github.sashirestela.cleverclient.support.ContentType;
import io.github.sashirestela.openai.OpenAI;
import io.github.sashirestela.openai.OpenAIBeta2;
import io.github.sashirestela.openai.base.ClientConfig;
import io.github.sashirestela.openai.base.OpenAIConfigurator;
import io.github.sashirestela.openai.base.OpenAIProvider;
import io.github.sashirestela.openai.service.AssistantServices;
import io.github.sashirestela.openai.service.ChatCompletionServices;
import io.github.sashirestela.openai.service.FileServices;
import java.net.http.HttpClient;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;

public class SimpleOpenAIAzure
extends OpenAIProvider
implements ChatCompletionServices,
FileServices,
AssistantServices {
    public SimpleOpenAIAzure(@NonNull String apiKey, @NonNull String baseUrl, @NonNull String apiVersion, HttpClient httpClient, HttpClientAdapter clientAdapter, RetryConfig retryConfig, ObjectMapper objectMapper) {
        super(((AzureConfigurator.AzureConfiguratorBuilder)((AzureConfigurator.AzureConfiguratorBuilder)((AzureConfigurator.AzureConfiguratorBuilder)((AzureConfigurator.AzureConfiguratorBuilder)((OpenAIConfigurator.OpenAIConfiguratorBuilder)((AzureConfigurator.AzureConfiguratorBuilder)((AzureConfigurator.AzureConfiguratorBuilder)AzureConfigurator.builder().apiKey(apiKey)).baseUrl(baseUrl)).apiVersion(apiVersion)).httpClient(httpClient)).clientAdapter(clientAdapter)).retryConfig(retryConfig)).objectMapper(objectMapper)).build());
        if (apiKey == null) {
            throw new NullPointerException("apiKey is marked non-null but is null");
        }
        if (baseUrl == null) {
            throw new NullPointerException("baseUrl is marked non-null but is null");
        }
        if (apiVersion == null) {
            throw new NullPointerException("apiVersion is marked non-null but is null");
        }
    }

    @Override
    public OpenAI.ChatCompletions chatCompletions() {
        return this.getOrCreateService(OpenAI.ChatCompletions.class);
    }

    @Override
    public OpenAI.Files files() {
        return this.getOrCreateService(OpenAI.Files.class);
    }

    @Override
    public OpenAIBeta2.Assistants assistants() {
        return this.getOrCreateService(OpenAIBeta2.Assistants.class);
    }

    @Override
    public OpenAIBeta2.ThreadMessages threadMessages() {
        return this.getOrCreateService(OpenAIBeta2.ThreadMessages.class);
    }

    @Override
    public OpenAIBeta2.ThreadRunSteps threadRunSteps() {
        return this.getOrCreateService(OpenAIBeta2.ThreadRunSteps.class);
    }

    @Override
    public OpenAIBeta2.ThreadRuns threadRuns() {
        return this.getOrCreateService(OpenAIBeta2.ThreadRuns.class);
    }

    @Override
    public OpenAIBeta2.Threads threads() {
        return this.getOrCreateService(OpenAIBeta2.Threads.class);
    }

    @Override
    public OpenAIBeta2.VectorStoreFileBatches vectorStoreFileBatches() {
        return this.getOrCreateService(OpenAIBeta2.VectorStoreFileBatches.class);
    }

    @Override
    public OpenAIBeta2.VectorStoreFiles vectorStoreFiles() {
        return this.getOrCreateService(OpenAIBeta2.VectorStoreFiles.class);
    }

    @Override
    public OpenAIBeta2.VectorStores vectorStores() {
        return this.getOrCreateService(OpenAIBeta2.VectorStores.class);
    }

    @Generated
    public static SimpleOpenAIAzureBuilder builder() {
        return new SimpleOpenAIAzureBuilder();
    }

    @Generated
    public static class SimpleOpenAIAzureBuilder {
        @Generated
        private String apiKey;
        @Generated
        private String baseUrl;
        @Generated
        private String apiVersion;
        @Generated
        private HttpClient httpClient;
        @Generated
        private HttpClientAdapter clientAdapter;
        @Generated
        private RetryConfig retryConfig;
        @Generated
        private ObjectMapper objectMapper;

        @Generated
        SimpleOpenAIAzureBuilder() {
        }

        @Generated
        public SimpleOpenAIAzureBuilder apiKey(@NonNull String apiKey) {
            if (apiKey == null) {
                throw new NullPointerException("apiKey is marked non-null but is null");
            }
            this.apiKey = apiKey;
            return this;
        }

        @Generated
        public SimpleOpenAIAzureBuilder baseUrl(@NonNull String baseUrl) {
            if (baseUrl == null) {
                throw new NullPointerException("baseUrl is marked non-null but is null");
            }
            this.baseUrl = baseUrl;
            return this;
        }

        @Generated
        public SimpleOpenAIAzureBuilder apiVersion(@NonNull String apiVersion) {
            if (apiVersion == null) {
                throw new NullPointerException("apiVersion is marked non-null but is null");
            }
            this.apiVersion = apiVersion;
            return this;
        }

        @Generated
        public SimpleOpenAIAzureBuilder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        @Generated
        public SimpleOpenAIAzureBuilder clientAdapter(HttpClientAdapter clientAdapter) {
            this.clientAdapter = clientAdapter;
            return this;
        }

        @Generated
        public SimpleOpenAIAzureBuilder retryConfig(RetryConfig retryConfig) {
            this.retryConfig = retryConfig;
            return this;
        }

        @Generated
        public SimpleOpenAIAzureBuilder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        @Generated
        public SimpleOpenAIAzure build() {
            return new SimpleOpenAIAzure(this.apiKey, this.baseUrl, this.apiVersion, this.httpClient, this.clientAdapter, this.retryConfig, this.objectMapper);
        }

        @Generated
        public String toString() {
            return "SimpleOpenAIAzure.SimpleOpenAIAzureBuilder(apiKey=" + this.apiKey + ", baseUrl=" + this.baseUrl + ", apiVersion=" + this.apiVersion + ", httpClient=" + String.valueOf(this.httpClient) + ", clientAdapter=" + String.valueOf(this.clientAdapter) + ", retryConfig=" + String.valueOf(this.retryConfig) + ", objectMapper=" + String.valueOf(this.objectMapper) + ")";
        }
    }

    static class AzureConfigurator
    extends OpenAIConfigurator {
        private String apiVersion;

        @Override
        public ClientConfig buildConfig() {
            return ClientConfig.builder().baseUrl(this.baseUrl).headers(Map.of("api-key", this.apiKey)).httpClient(this.httpClient).clientAdapter(this.clientAdapter).retryConfig(this.retryConfig).requestInterceptor(this.makeRequestInterceptor()).objectMapper(this.objectMapper).build();
        }

        private UnaryOperator<HttpRequestData> makeRequestInterceptor() {
            return request -> {
                String url = request.getUrl();
                ContentType contentType = request.getContentType();
                if (contentType != null) {
                    Object body = this.makeNewBody((HttpRequestData)request, contentType, url);
                    request.setBody(body);
                }
                url = this.makeNewUrl(url, this.apiVersion);
                request.setUrl(url);
                return request;
            };
        }

        private Object makeNewBody(HttpRequestData request, ContentType contentType, String url) {
            String deployment = this.extractDeployment(url);
            Object body = request.getBody();
            if (contentType.equals((Object)ContentType.APPLICATION_JSON)) {
                return this.getBodyForJson(url, (String)body, deployment);
            }
            return this.getBodyForMap(url, (Map)body, deployment);
        }

        private String makeNewUrl(String url, String apiVersion) {
            String VERSION_REGEX = "(/v\\d+\\.*\\d*)";
            String DEPLOYMENT_REGEX = "/deployments/[^/]+/";
            String CHAT_COMPLETIONS_LITERAL = "/chat/completions";
            url = (String)url + (((String)url).contains("?") ? "&" : "?") + "api-version=" + apiVersion;
            if (!((String)(url = ((String)url).replaceFirst("(/v\\d+\\.*\\d*)", ""))).contains("/chat/completions")) {
                url = ((String)url).replaceFirst("/deployments/[^/]+/", "/");
            }
            return url;
        }

        private String extractDeployment(String url) {
            String DEPLOYMENT_REGEX = "/deployments/([^/]+)/";
            Pattern pattern = Pattern.compile("/deployments/([^/]+)/");
            Matcher matcher = pattern.matcher(url);
            if (matcher.find()) {
                return matcher.group(1);
            }
            return null;
        }

        private Object getBodyForJson(String url, String body, String deployment) {
            String MODEL_ENTRY_REGEX = "\"model\"\\s*:\\s*\"[^\"]+\"\\s*,?\\s*";
            String TRAILING_COMMA_REGEX = ",\\s*}";
            String CLOSING_BRACE = "}";
            String MODEL_LITERAL = "model";
            String ASSISTANTS_LITERAL = "/assistants";
            Object model = "";
            if (url.contains("/assistants")) {
                model = "\"model\":\"" + deployment + "\",";
            }
            body = body.replaceFirst("\"model\"\\s*:\\s*\"[^\"]+\"\\s*,?\\s*", (String)model);
            body = body.replaceFirst(",\\s*}", "}");
            return body;
        }

        private Object getBodyForMap(String url, Map<String, Object> body, String deployment) {
            String ASSISTANTS_LITERAL = "/assistants";
            String MODEL_LITERAL = "model";
            if (url.contains("/assistants")) {
                body.put("model", deployment);
            } else {
                body.remove("model");
            }
            return body;
        }

        @Generated
        protected AzureConfigurator(AzureConfiguratorBuilder<?, ?> b) {
            super(b);
            this.apiVersion = b.apiVersion;
        }

        @Generated
        public static AzureConfiguratorBuilder<?, ?> builder() {
            return new AzureConfiguratorBuilderImpl();
        }

        @Generated
        private static final class AzureConfiguratorBuilderImpl
        extends AzureConfiguratorBuilder<AzureConfigurator, AzureConfiguratorBuilderImpl> {
            @Generated
            private AzureConfiguratorBuilderImpl() {
            }

            @Override
            @Generated
            protected AzureConfiguratorBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public AzureConfigurator build() {
                return new AzureConfigurator(this);
            }
        }

        @Generated
        public static abstract class AzureConfiguratorBuilder<C extends AzureConfigurator, B extends AzureConfiguratorBuilder<C, B>>
        extends OpenAIConfigurator.OpenAIConfiguratorBuilder<C, B> {
            @Generated
            private String apiVersion;

            @Generated
            public B apiVersion(String apiVersion) {
                this.apiVersion = apiVersion;
                return (B)this.self();
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "SimpleOpenAIAzure.AzureConfigurator.AzureConfiguratorBuilder(super=" + super.toString() + ", apiVersion=" + this.apiVersion + ")";
            }
        }
    }
}

