/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.realtime;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.domain.chat.ChatRequest;
import io.github.sashirestela.openai.domain.realtime.RealtimeSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class RealtimeTranscriptionSession {
    private String id;
    private String object;
    private RealtimeSession.SecretConfig clientSecret;
    private List<ItemsToInclude> include;
    protected RealtimeSession.AudioFormatRealtime inputAudioFormat;
    private RealtimeSession.InputAudioNoiseReduction inputAudioNoiseReduction;
    protected RealtimeSession.InputAudioTranscription inputAudioTranscription;
    @Deprecated(forRemoval=false)
    protected List<ChatRequest.Modality> modalities;
    protected RealtimeSession.TurnDetection turnDetection;

    @Generated
    protected RealtimeTranscriptionSession(RealtimeTranscriptionSessionBuilder<?, ?> b) {
        List<Object> modalities;
        this.id = b.id;
        this.object = b.object;
        this.clientSecret = b.clientSecret;
        this.include = b.include;
        this.inputAudioFormat = b.inputAudioFormat;
        this.inputAudioNoiseReduction = b.inputAudioNoiseReduction;
        this.inputAudioTranscription = b.inputAudioTranscription;
        switch (b.modalities == null ? 0 : b.modalities.size()) {
            case 0: {
                modalities = Collections.emptyList();
                break;
            }
            case 1: {
                modalities = Collections.singletonList(b.modalities.get(0));
                break;
            }
            default: {
                modalities = Collections.unmodifiableList(new ArrayList<ChatRequest.Modality>(b.modalities));
            }
        }
        this.modalities = modalities;
        this.turnDetection = b.turnDetection;
    }

    @Generated
    public static RealtimeTranscriptionSessionBuilder<?, ?> builder() {
        return new RealtimeTranscriptionSessionBuilderImpl();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public RealtimeSession.SecretConfig getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public List<ItemsToInclude> getInclude() {
        return this.include;
    }

    @Generated
    public RealtimeSession.AudioFormatRealtime getInputAudioFormat() {
        return this.inputAudioFormat;
    }

    @Generated
    public RealtimeSession.InputAudioNoiseReduction getInputAudioNoiseReduction() {
        return this.inputAudioNoiseReduction;
    }

    @Generated
    public RealtimeSession.InputAudioTranscription getInputAudioTranscription() {
        return this.inputAudioTranscription;
    }

    @Deprecated
    @Generated
    public List<ChatRequest.Modality> getModalities() {
        return this.modalities;
    }

    @Generated
    public RealtimeSession.TurnDetection getTurnDetection() {
        return this.turnDetection;
    }

    @Generated
    public String toString() {
        return "RealtimeTranscriptionSession(id=" + this.getId() + ", object=" + this.getObject() + ", clientSecret=" + String.valueOf(this.getClientSecret()) + ", include=" + String.valueOf(this.getInclude()) + ", inputAudioFormat=" + String.valueOf((Object)this.getInputAudioFormat()) + ", inputAudioNoiseReduction=" + String.valueOf(this.getInputAudioNoiseReduction()) + ", inputAudioTranscription=" + String.valueOf(this.getInputAudioTranscription()) + ", modalities=" + String.valueOf(this.getModalities()) + ", turnDetection=" + String.valueOf(this.getTurnDetection()) + ")";
    }

    @Generated
    public RealtimeTranscriptionSession() {
    }

    @Generated
    public RealtimeTranscriptionSession(String id, String object, RealtimeSession.SecretConfig clientSecret, List<ItemsToInclude> include, RealtimeSession.AudioFormatRealtime inputAudioFormat, RealtimeSession.InputAudioNoiseReduction inputAudioNoiseReduction, RealtimeSession.InputAudioTranscription inputAudioTranscription, List<ChatRequest.Modality> modalities, RealtimeSession.TurnDetection turnDetection) {
        this.id = id;
        this.object = object;
        this.clientSecret = clientSecret;
        this.include = include;
        this.inputAudioFormat = inputAudioFormat;
        this.inputAudioNoiseReduction = inputAudioNoiseReduction;
        this.inputAudioTranscription = inputAudioTranscription;
        this.modalities = modalities;
        this.turnDetection = turnDetection;
    }

    @Generated
    private static final class RealtimeTranscriptionSessionBuilderImpl
    extends RealtimeTranscriptionSessionBuilder<RealtimeTranscriptionSession, RealtimeTranscriptionSessionBuilderImpl> {
        @Generated
        private RealtimeTranscriptionSessionBuilderImpl() {
        }

        @Override
        @Generated
        protected RealtimeTranscriptionSessionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public RealtimeTranscriptionSession build() {
            return new RealtimeTranscriptionSession(this);
        }
    }

    @Generated
    public static abstract class RealtimeTranscriptionSessionBuilder<C extends RealtimeTranscriptionSession, B extends RealtimeTranscriptionSessionBuilder<C, B>> {
        @Generated
        private String id;
        @Generated
        private String object;
        @Generated
        private RealtimeSession.SecretConfig clientSecret;
        @Generated
        private List<ItemsToInclude> include;
        @Generated
        private RealtimeSession.AudioFormatRealtime inputAudioFormat;
        @Generated
        private RealtimeSession.InputAudioNoiseReduction inputAudioNoiseReduction;
        @Generated
        private RealtimeSession.InputAudioTranscription inputAudioTranscription;
        @Generated
        private ArrayList<ChatRequest.Modality> modalities;
        @Generated
        private RealtimeSession.TurnDetection turnDetection;

        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B object(String object) {
            this.object = object;
            return this.self();
        }

        @Generated
        public B clientSecret(RealtimeSession.SecretConfig clientSecret) {
            this.clientSecret = clientSecret;
            return this.self();
        }

        @Generated
        public B include(List<ItemsToInclude> include) {
            this.include = include;
            return this.self();
        }

        @Generated
        public B inputAudioFormat(RealtimeSession.AudioFormatRealtime inputAudioFormat) {
            this.inputAudioFormat = inputAudioFormat;
            return this.self();
        }

        @Generated
        public B inputAudioNoiseReduction(RealtimeSession.InputAudioNoiseReduction inputAudioNoiseReduction) {
            this.inputAudioNoiseReduction = inputAudioNoiseReduction;
            return this.self();
        }

        @Generated
        public B inputAudioTranscription(RealtimeSession.InputAudioTranscription inputAudioTranscription) {
            this.inputAudioTranscription = inputAudioTranscription;
            return this.self();
        }

        @Deprecated
        @Generated
        public B modality(ChatRequest.Modality modality) {
            if (this.modalities == null) {
                this.modalities = new ArrayList();
            }
            this.modalities.add(modality);
            return this.self();
        }

        @Deprecated
        @Generated
        public B modalities(Collection<? extends ChatRequest.Modality> modalities) {
            if (modalities == null) {
                throw new NullPointerException("modalities cannot be null");
            }
            if (this.modalities == null) {
                this.modalities = new ArrayList();
            }
            this.modalities.addAll(modalities);
            return this.self();
        }

        @Deprecated
        @Generated
        public B clearModalities() {
            if (this.modalities != null) {
                this.modalities.clear();
            }
            return this.self();
        }

        @Generated
        public B turnDetection(RealtimeSession.TurnDetection turnDetection) {
            this.turnDetection = turnDetection;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "RealtimeTranscriptionSession.RealtimeTranscriptionSessionBuilder(id=" + this.id + ", object=" + this.object + ", clientSecret=" + String.valueOf(this.clientSecret) + ", include=" + String.valueOf(this.include) + ", inputAudioFormat=" + String.valueOf((Object)this.inputAudioFormat) + ", inputAudioNoiseReduction=" + String.valueOf(this.inputAudioNoiseReduction) + ", inputAudioTranscription=" + String.valueOf(this.inputAudioTranscription) + ", modalities=" + String.valueOf(this.modalities) + ", turnDetection=" + String.valueOf(this.turnDetection) + ")";
        }
    }

    public static enum ItemsToInclude {
        LOGPROBS;

    }
}

