/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.finetuning;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.slimvalidator.constraints.Required;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class Integration {
    @Required
    private IntegrationType type;
    @Required
    private WandbIntegration wandb;

    @Generated
    public static IntegrationBuilder builder() {
        return new IntegrationBuilder();
    }

    @Generated
    public Integration() {
    }

    @Generated
    public Integration(IntegrationType type, WandbIntegration wandb) {
        this.type = type;
        this.wandb = wandb;
    }

    @Generated
    public IntegrationType getType() {
        return this.type;
    }

    @Generated
    public WandbIntegration getWandb() {
        return this.wandb;
    }

    @Generated
    public static class IntegrationBuilder {
        @Generated
        private IntegrationType type;
        @Generated
        private WandbIntegration wandb;

        @Generated
        IntegrationBuilder() {
        }

        @Generated
        public IntegrationBuilder type(IntegrationType type) {
            this.type = type;
            return this;
        }

        @Generated
        public IntegrationBuilder wandb(WandbIntegration wandb) {
            this.wandb = wandb;
            return this;
        }

        @Generated
        public Integration build() {
            return new Integration(this.type, this.wandb);
        }

        @Generated
        public String toString() {
            return "Integration.IntegrationBuilder(type=" + String.valueOf((Object)this.type) + ", wandb=" + String.valueOf(this.wandb) + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class WandbIntegration {
        @Required
        private String project;
        private String name;
        private String entity;
        private List<String> tags;

        @Generated
        public static WandbIntegrationBuilder builder() {
            return new WandbIntegrationBuilder();
        }

        @Generated
        public WandbIntegration() {
        }

        @Generated
        public WandbIntegration(String project, String name, String entity, List<String> tags) {
            this.project = project;
            this.name = name;
            this.entity = entity;
            this.tags = tags;
        }

        @Generated
        public String getProject() {
            return this.project;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getEntity() {
            return this.entity;
        }

        @Generated
        public List<String> getTags() {
            return this.tags;
        }

        @Generated
        public static class WandbIntegrationBuilder {
            @Generated
            private String project;
            @Generated
            private String name;
            @Generated
            private String entity;
            @Generated
            private ArrayList<String> tags;

            @Generated
            WandbIntegrationBuilder() {
            }

            @Generated
            public WandbIntegrationBuilder project(String project) {
                this.project = project;
                return this;
            }

            @Generated
            public WandbIntegrationBuilder name(String name) {
                this.name = name;
                return this;
            }

            @Generated
            public WandbIntegrationBuilder entity(String entity) {
                this.entity = entity;
                return this;
            }

            @Generated
            public WandbIntegrationBuilder tag(String tag) {
                if (this.tags == null) {
                    this.tags = new ArrayList();
                }
                this.tags.add(tag);
                return this;
            }

            @Generated
            public WandbIntegrationBuilder tags(Collection<? extends String> tags) {
                if (tags == null) {
                    throw new NullPointerException("tags cannot be null");
                }
                if (this.tags == null) {
                    this.tags = new ArrayList();
                }
                this.tags.addAll(tags);
                return this;
            }

            @Generated
            public WandbIntegrationBuilder clearTags() {
                if (this.tags != null) {
                    this.tags.clear();
                }
                return this;
            }

            @Generated
            public WandbIntegration build() {
                List<String> tags;
                switch (this.tags == null ? 0 : this.tags.size()) {
                    case 0: {
                        tags = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        tags = Collections.singletonList(this.tags.get(0));
                        break;
                    }
                    default: {
                        tags = Collections.unmodifiableList(new ArrayList<String>(this.tags));
                    }
                }
                return new WandbIntegration(this.project, this.name, this.entity, tags);
            }

            @Generated
            public String toString() {
                return "Integration.WandbIntegration.WandbIntegrationBuilder(project=" + this.project + ", name=" + this.name + ", entity=" + this.entity + ", tags=" + String.valueOf(this.tags) + ")";
            }
        }
    }

    public static enum IntegrationType {
        WANDB;

    }
}

