/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.assistant;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.slimvalidator.constraints.Required;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class ThreadRunSubmitOutputRequest {
    @Required
    private List<ToolOutput> toolOutputs;
    private Boolean stream;

    @Generated
    ThreadRunSubmitOutputRequest(List<ToolOutput> toolOutputs, Boolean stream) {
        this.toolOutputs = toolOutputs;
        this.stream = stream;
    }

    @Generated
    public static ThreadRunSubmitOutputRequestBuilder builder() {
        return new ThreadRunSubmitOutputRequestBuilder();
    }

    @Generated
    public List<ToolOutput> getToolOutputs() {
        return this.toolOutputs;
    }

    @Generated
    public Boolean getStream() {
        return this.stream;
    }

    @Generated
    public ThreadRunSubmitOutputRequest withStream(Boolean stream) {
        return this.stream == stream ? this : new ThreadRunSubmitOutputRequest(this.toolOutputs, stream);
    }

    @Generated
    public static class ThreadRunSubmitOutputRequestBuilder {
        @Generated
        private ArrayList<ToolOutput> toolOutputs;
        @Generated
        private Boolean stream;

        @Generated
        ThreadRunSubmitOutputRequestBuilder() {
        }

        @Generated
        public ThreadRunSubmitOutputRequestBuilder toolOutput(ToolOutput toolOutput) {
            if (this.toolOutputs == null) {
                this.toolOutputs = new ArrayList();
            }
            this.toolOutputs.add(toolOutput);
            return this;
        }

        @Generated
        public ThreadRunSubmitOutputRequestBuilder toolOutputs(Collection<? extends ToolOutput> toolOutputs) {
            if (toolOutputs == null) {
                throw new NullPointerException("toolOutputs cannot be null");
            }
            if (this.toolOutputs == null) {
                this.toolOutputs = new ArrayList();
            }
            this.toolOutputs.addAll(toolOutputs);
            return this;
        }

        @Generated
        public ThreadRunSubmitOutputRequestBuilder clearToolOutputs() {
            if (this.toolOutputs != null) {
                this.toolOutputs.clear();
            }
            return this;
        }

        @Generated
        public ThreadRunSubmitOutputRequestBuilder stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        @Generated
        public ThreadRunSubmitOutputRequest build() {
            List<ToolOutput> toolOutputs;
            switch (this.toolOutputs == null ? 0 : this.toolOutputs.size()) {
                case 0: {
                    toolOutputs = Collections.emptyList();
                    break;
                }
                case 1: {
                    toolOutputs = Collections.singletonList(this.toolOutputs.get(0));
                    break;
                }
                default: {
                    toolOutputs = Collections.unmodifiableList(new ArrayList<ToolOutput>(this.toolOutputs));
                }
            }
            return new ThreadRunSubmitOutputRequest(toolOutputs, this.stream);
        }

        @Generated
        public String toString() {
            return "ThreadRunSubmitOutputRequest.ThreadRunSubmitOutputRequestBuilder(toolOutputs=" + String.valueOf(this.toolOutputs) + ", stream=" + this.stream + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class ToolOutput {
        private String toolCallId;
        private String output;

        @Generated
        ToolOutput(String toolCallId, String output) {
            this.toolCallId = toolCallId;
            this.output = output;
        }

        @Generated
        public static ToolOutputBuilder builder() {
            return new ToolOutputBuilder();
        }

        @Generated
        public String getToolCallId() {
            return this.toolCallId;
        }

        @Generated
        public String getOutput() {
            return this.output;
        }

        @Generated
        public String toString() {
            return "ThreadRunSubmitOutputRequest.ToolOutput(toolCallId=" + this.getToolCallId() + ", output=" + this.getOutput() + ")";
        }

        @Generated
        public static class ToolOutputBuilder {
            @Generated
            private String toolCallId;
            @Generated
            private String output;

            @Generated
            ToolOutputBuilder() {
            }

            @Generated
            public ToolOutputBuilder toolCallId(String toolCallId) {
                this.toolCallId = toolCallId;
                return this;
            }

            @Generated
            public ToolOutputBuilder output(String output) {
                this.output = output;
                return this;
            }

            @Generated
            public ToolOutput build() {
                return new ToolOutput(this.toolCallId, this.output);
            }

            @Generated
            public String toString() {
                return "ThreadRunSubmitOutputRequest.ToolOutput.ToolOutputBuilder(toolCallId=" + this.toolCallId + ", output=" + this.output + ")";
            }
        }
    }
}

