/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.common.function;

import io.github.sashirestela.cleverclient.util.CommonUtil;
import io.github.sashirestela.cleverclient.util.JsonUtil;
import io.github.sashirestela.openai.common.function.FunctionCall;
import io.github.sashirestela.openai.common.function.FunctionDef;
import io.github.sashirestela.openai.common.function.Functional;
import io.github.sashirestela.openai.common.tool.Tool;
import io.github.sashirestela.openai.common.tool.ToolCall;
import io.github.sashirestela.openai.common.tool.ToolChoice;
import io.github.sashirestela.openai.common.tool.ToolChoiceOption;
import io.github.sashirestela.openai.exception.SimpleOpenAIException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class FunctionExecutor {
    private Map<String, FunctionDef> mapFunctions = new HashMap<String, FunctionDef>();

    public FunctionExecutor() {
    }

    public FunctionExecutor(List<FunctionDef> functions) {
        this.enrollFunctions(functions);
    }

    public List<Tool> getToolFunctions() {
        return this.mapFunctions.values().stream().map(Tool::function).collect(Collectors.toList());
    }

    public List<Tool> getToolFunctions(Object toolChoice) {
        if (toolChoice instanceof ToolChoiceOption) {
            ToolChoiceOption choice = (ToolChoiceOption)((Object)toolChoice);
            if (choice.equals((Object)ToolChoiceOption.NONE)) {
                return Arrays.asList(new Tool[0]);
            }
            return this.getToolFunctions();
        }
        if (toolChoice instanceof ToolChoice) {
            String functionName = ((ToolChoice)toolChoice).getFunction().getName();
            if (!this.mapFunctions.containsKey(functionName)) {
                throw new SimpleOpenAIException("The function {0} was not enrolled in the executor.", functionName, null);
            }
            return Arrays.asList(Tool.function(this.mapFunctions.get(functionName)));
        }
        throw new SimpleOpenAIException("The object {0} is of an unexpected type.", toolChoice.toString(), null);
    }

    public void enrollFunction(FunctionDef function) {
        this.mapFunctions.put(function.getName(), function);
    }

    public void enrollFunctions(List<FunctionDef> functions) {
        if (functions == null) {
            throw new SimpleOpenAIException("No functions were entered.", "", null);
        }
        this.mapFunctions.clear();
        functions.forEach(this::enrollFunction);
    }

    public <T> T execute(String name, String arguments) {
        FunctionCall functionCall = new FunctionCall(name, arguments);
        return this.execute(functionCall);
    }

    public <T> T execute(FunctionCall functionCall) {
        if (functionCall == null || CommonUtil.isNullOrEmpty((Object)functionCall.getName())) {
            throw new SimpleOpenAIException("No function was entered or it does not has a name.", "", null);
        }
        String functionName = functionCall.getName();
        if (!this.mapFunctions.containsKey(functionName)) {
            throw new SimpleOpenAIException("The function {0} was not enrolled in the executor.", functionName, null);
        }
        try {
            FunctionDef function = this.mapFunctions.get(functionName);
            Functional object = (Functional)JsonUtil.jsonToObject((String)(functionCall.getArguments().isBlank() ? "{}" : functionCall.getArguments()), function.getFunctionalClass());
            return (T)object.execute();
        }
        catch (RuntimeException e) {
            throw new SimpleOpenAIException("Cannot execute the function {0}.", functionName, e);
        }
    }

    public <R> List<R> executeAll(List<ToolCall> toolCalls, BiFunction<String, String, R> toolOutputItem) {
        ArrayList<R> toolOutputs = new ArrayList<R>();
        for (ToolCall toolCall : toolCalls) {
            if (toolCall.getFunction() == null) continue;
            Object result = this.execute(toolCall.getFunction());
            R item = toolOutputItem.apply(toolCall.getId(), result.toString());
            toolOutputs.add(item);
        }
        return toolOutputs;
    }
}

