/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.base;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.sashirestela.cleverclient.CleverClient;
import io.github.sashirestela.cleverclient.client.JavaHttpClientAdapter;
import io.github.sashirestela.cleverclient.retry.RetryConfig;
import io.github.sashirestela.openai.OpenAIRealtime;
import io.github.sashirestela.openai.base.ClientConfig;
import io.github.sashirestela.openai.base.OpenAIConfigurator;
import io.github.sashirestela.openai.base.RealtimeConfig;
import io.github.sashirestela.slimvalidator.Validator;
import io.github.sashirestela.slimvalidator.exception.ConstraintViolationException;
import java.net.http.HttpClient;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;

public abstract class OpenAIProvider {
    protected CleverClient cleverClient;
    protected OpenAIRealtime realtime;
    private Map<Class<?>, Object> serviceCache = new ConcurrentHashMap();

    protected OpenAIProvider(@NonNull OpenAIConfigurator configurator) {
        if (configurator == null) {
            throw new NullPointerException("configurator is marked non-null but is null");
        }
        ClientConfig clientConfig = configurator.buildConfig();
        this.cleverClient = this.buildClient(clientConfig);
        this.realtime = this.buildRealtime(clientConfig);
    }

    protected <T> T getOrCreateService(Class<T> serviceClass) {
        return (T)this.serviceCache.computeIfAbsent(serviceClass, key -> this.cleverClient.create(serviceClass));
    }

    public void shutDown() {
        this.cleverClient.getClientAdapter().shutdown();
    }

    private CleverClient buildClient(ClientConfig clientConfig) {
        String END_OF_STREAM = "[DONE]";
        return CleverClient.builder().clientAdapter(Optional.ofNullable(clientConfig.getClientAdapter()).orElseGet(() -> new JavaHttpClientAdapter(Optional.ofNullable(clientConfig.getHttpClient()).orElse(HttpClient.newHttpClient())))).baseUrl(clientConfig.getBaseUrl()).headers(clientConfig.getHeaders()).bodyInspector(this.bodyInspector()).requestInterceptor(clientConfig.getRequestInterceptor()).responseInterceptor(clientConfig.getResponseInterceptor()).retryConfig(Optional.ofNullable(clientConfig.getRetryConfig()).orElse(RetryConfig.defaultValues())).endOfStream("[DONE]").objectMapper(Optional.ofNullable(clientConfig.getObjectMapper()).orElse(new ObjectMapper())).build();
    }

    private OpenAIRealtime buildRealtime(ClientConfig clientConfig) {
        RealtimeConfig realtimeConfig = clientConfig.getRealtimeConfig();
        if (realtimeConfig != null) {
            return new OpenAIRealtime(realtimeConfig);
        }
        return null;
    }

    private Consumer<Object> bodyInspector() {
        return body -> {
            Validator validator = new Validator();
            List violations = validator.validate(body);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        };
    }

    @Generated
    public void setCleverClient(CleverClient cleverClient) {
        this.cleverClient = cleverClient;
    }
}

