/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.response;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.common.function.FunctionDef;
import io.github.sashirestela.openai.domain.assistant.RankingOption;
import io.github.sashirestela.openai.domain.response.FilterDeserializer;
import io.github.sashirestela.slimvalidator.constraints.ObjectType;
import io.github.sashirestela.slimvalidator.constraints.Range;
import io.github.sashirestela.slimvalidator.constraints.Required;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=FileSearchResponseTool.class, name="file_search"), @JsonSubTypes.Type(value=FunctionResponseTool.class, name="function"), @JsonSubTypes.Type(value=ComputerResponseTool.class, name="computer_use_preview"), @JsonSubTypes.Type(value=WebSearchResponseTool.class, name="web_search_preview"), @JsonSubTypes.Type(value=McpResponseTool.class, name="mcp"), @JsonSubTypes.Type(value=CodeInterpreterResponseTool.class, name="code_interpreter"), @JsonSubTypes.Type(value=ImageGenerationResponseTool.class, name="image_generation"), @JsonSubTypes.Type(value=LocalShellResponseTool.class, name="local_shell")})
public abstract class ResponseTool {
    protected ResponseToolType type;

    @Generated
    public ResponseToolType getType() {
        return this.type;
    }

    @Generated
    public void setType(ResponseToolType type) {
        this.type = type;
    }

    public static class ContainerDeserializer
    extends JsonDeserializer<Object> {
        public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonToken token = p.getCurrentToken();
            if (token == JsonToken.VALUE_STRING) {
                return p.getValueAsString();
            }
            if (token == JsonToken.START_OBJECT) {
                JsonNode node = (JsonNode)p.getCodec().readTree(p);
                ObjectMapper mapper = (ObjectMapper)p.getCodec();
                if (node.has("type") && "auto".equals(node.get("type").asText())) {
                    return mapper.treeToValue((TreeNode)node, ContainerAuto.class);
                }
                throw new IOException("Invalid object for container field: expected ContainerAuto with type 'auto'");
            }
            throw new IOException("Unable to deserialize container: expected string or ContainerAuto object");
        }
    }

    public static class RequireApprovalDeserializer
    extends JsonDeserializer<Object> {
        public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            ObjectMapper mapper = (ObjectMapper)p.getCodec();
            if (node.isTextual()) {
                String value = node.asText();
                try {
                    return McpToolApprovalSetting.valueOf(value.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    throw new IOException("Invalid McpToolApprovalSetting value: " + value, e);
                }
            }
            if (node.isObject() && (node.has("always") || node.has("never"))) {
                return mapper.treeToValue((TreeNode)node, McpToolApprovalFilter.class);
            }
            throw new IOException("Unable to deserialize requireApproval: expected string (enum) or McpToolApprovalFilter object");
        }
    }

    public static class AllowedToolsDeserializer
    extends JsonDeserializer<Object> {
        public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            ObjectMapper mapper = (ObjectMapper)p.getCodec();
            if (node.isArray()) {
                ArrayList<String> toolNames = new ArrayList<String>();
                for (JsonNode element : node) {
                    if (!element.isTextual()) continue;
                    toolNames.add(element.asText());
                }
                return toolNames;
            }
            if (node.isObject() && node.has("tool_names")) {
                return mapper.treeToValue((TreeNode)node, McpListTools.class);
            }
            throw new IOException("Unable to deserialize allowedTools: expected array of strings or McpListTools object");
        }
    }

    public static enum ImageQuality {
        LOW,
        MEDIUM,
        HIGH,
        AUTO;

    }

    public static enum ImageFormat {
        PNG,
        WEBP,
        JPEG;

    }

    public static enum ImageBackground {
        TRANSPARENT,
        OPAQUE,
        AUTO;

    }

    public static enum McpToolApprovalSetting {
        ALWAYS,
        NEVER;

    }

    public static enum ContextSize {
        LOW,
        MEDIUM,
        HIGH;

    }

    public static enum Environment {
        MAC,
        WINDOWS,
        UBUNTU,
        BROWSER;

    }

    public static enum LogicalOperator {
        AND,
        OR;

    }

    public static enum ComparisonOperator {
        EQ,
        NE,
        GT,
        GTE,
        LT,
        LTE;

    }

    public static enum ResponseToolType {
        FILE_SEARCH,
        FUNCTION,
        COMPUTER_USE_PREVIEW,
        WEB_SEARCH_PREVIEW,
        MCP,
        CODE_INTERPRETER,
        IMAGE_GENERATION,
        LOCAL_SHELL;

    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class ImageMask {
        private String fileId;
        private String imageUrl;

        @Generated
        public static ImageMaskBuilder builder() {
            return new ImageMaskBuilder();
        }

        @Generated
        public ImageMask() {
        }

        @Generated
        public ImageMask(String fileId, String imageUrl) {
            this.fileId = fileId;
            this.imageUrl = imageUrl;
        }

        @Generated
        public String getFileId() {
            return this.fileId;
        }

        @Generated
        public String getImageUrl() {
            return this.imageUrl;
        }

        @Generated
        public String toString() {
            return "ResponseTool.ImageMask(fileId=" + this.getFileId() + ", imageUrl=" + this.getImageUrl() + ")";
        }

        @Generated
        public static class ImageMaskBuilder {
            @Generated
            private String fileId;
            @Generated
            private String imageUrl;

            @Generated
            ImageMaskBuilder() {
            }

            @Generated
            public ImageMaskBuilder fileId(String fileId) {
                this.fileId = fileId;
                return this;
            }

            @Generated
            public ImageMaskBuilder imageUrl(String imageUrl) {
                this.imageUrl = imageUrl;
                return this;
            }

            @Generated
            public ImageMask build() {
                return new ImageMask(this.fileId, this.imageUrl);
            }

            @Generated
            public String toString() {
                return "ResponseTool.ImageMask.ImageMaskBuilder(fileId=" + this.fileId + ", imageUrl=" + this.imageUrl + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class ContainerAuto {
        private String type;
        private List<String> fileIds;

        private ContainerAuto(List<String> fileIds) {
            this.type = "auto";
            this.fileIds = fileIds;
        }

        public static ContainerAuto of(List<String> fileIds) {
            return new ContainerAuto(fileIds);
        }

        public static ContainerAuto of() {
            return new ContainerAuto(null);
        }

        @Generated
        public ContainerAuto() {
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public List<String> getFileIds() {
            return this.fileIds;
        }

        @Generated
        public String toString() {
            return "ResponseTool.ContainerAuto(type=" + this.getType() + ", fileIds=" + String.valueOf(this.getFileIds()) + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class McpToolApprovalFilter {
        private McpListTools always;
        private McpListTools never;

        public McpToolApprovalFilter(McpListTools always, McpListTools never) {
            this.always = always;
            this.never = never;
        }

        @Generated
        public static McpToolApprovalFilterBuilder builder() {
            return new McpToolApprovalFilterBuilder();
        }

        @Generated
        public McpToolApprovalFilter() {
        }

        @Generated
        public McpListTools getAlways() {
            return this.always;
        }

        @Generated
        public McpListTools getNever() {
            return this.never;
        }

        @Generated
        public String toString() {
            return "ResponseTool.McpToolApprovalFilter(always=" + String.valueOf(this.getAlways()) + ", never=" + String.valueOf(this.getNever()) + ")";
        }

        @Generated
        public static class McpToolApprovalFilterBuilder {
            @Generated
            private McpListTools always;
            @Generated
            private McpListTools never;

            @Generated
            McpToolApprovalFilterBuilder() {
            }

            @Generated
            public McpToolApprovalFilterBuilder always(McpListTools always) {
                this.always = always;
                return this;
            }

            @Generated
            public McpToolApprovalFilterBuilder never(McpListTools never) {
                this.never = never;
                return this;
            }

            @Generated
            public McpToolApprovalFilter build() {
                return new McpToolApprovalFilter(this.always, this.never);
            }

            @Generated
            public String toString() {
                return "ResponseTool.McpToolApprovalFilter.McpToolApprovalFilterBuilder(always=" + String.valueOf(this.always) + ", never=" + String.valueOf(this.never) + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class McpListTools {
        private List<String> toolNames;

        private McpListTools(List<String> toolNames) {
            this.toolNames = toolNames;
        }

        public static McpListTools of(List<String> toolNames) {
            return new McpListTools(toolNames);
        }

        @Generated
        public McpListTools() {
        }

        @Generated
        public List<String> getToolNames() {
            return this.toolNames;
        }

        @Generated
        public String toString() {
            return "ResponseTool.McpListTools(toolNames=" + String.valueOf(this.getToolNames()) + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class Location {
        private String type;
        private String city;
        private String country;
        private String region;
        private String timezone;

        public Location(String type, String city, String country, String region, String timezone) {
            this.type = "approximate";
            this.city = city;
            this.country = country;
            this.region = region;
            this.timezone = timezone;
        }

        @Generated
        public static LocationBuilder builder() {
            return new LocationBuilder();
        }

        @Generated
        public Location() {
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getCity() {
            return this.city;
        }

        @Generated
        public String getCountry() {
            return this.country;
        }

        @Generated
        public String getRegion() {
            return this.region;
        }

        @Generated
        public String getTimezone() {
            return this.timezone;
        }

        @Generated
        public String toString() {
            return "ResponseTool.Location(type=" + this.getType() + ", city=" + this.getCity() + ", country=" + this.getCountry() + ", region=" + this.getRegion() + ", timezone=" + this.getTimezone() + ")";
        }

        @Generated
        public static class LocationBuilder {
            @Generated
            private String type;
            @Generated
            private String city;
            @Generated
            private String country;
            @Generated
            private String region;
            @Generated
            private String timezone;

            @Generated
            LocationBuilder() {
            }

            @Generated
            public LocationBuilder type(String type) {
                this.type = type;
                return this;
            }

            @Generated
            public LocationBuilder city(String city) {
                this.city = city;
                return this;
            }

            @Generated
            public LocationBuilder country(String country) {
                this.country = country;
                return this;
            }

            @Generated
            public LocationBuilder region(String region) {
                this.region = region;
                return this;
            }

            @Generated
            public LocationBuilder timezone(String timezone) {
                this.timezone = timezone;
                return this;
            }

            @Generated
            public Location build() {
                return new Location(this.type, this.city, this.country, this.region, this.timezone);
            }

            @Generated
            public String toString() {
                return "ResponseTool.Location.LocationBuilder(type=" + this.type + ", city=" + this.city + ", country=" + this.country + ", region=" + this.region + ", timezone=" + this.timezone + ")";
            }
        }
    }

    public static interface Filter {

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class CompoundFilter
        implements Filter {
            @Required
            @JsonDeserialize(contentUsing=FilterDeserializer.class)
            private List<Filter> filters;
            @Required
            private LogicalOperator type;

            @Generated
            public static CompoundFilterBuilder builder() {
                return new CompoundFilterBuilder();
            }

            @Generated
            public CompoundFilter(List<Filter> filters, LogicalOperator type) {
                this.filters = filters;
                this.type = type;
            }

            @Generated
            public CompoundFilter() {
            }

            @Generated
            public List<Filter> getFilters() {
                return this.filters;
            }

            @Generated
            public LogicalOperator getType() {
                return this.type;
            }

            @Generated
            public String toString() {
                return "ResponseTool.Filter.CompoundFilter(filters=" + String.valueOf(this.getFilters()) + ", type=" + String.valueOf((Object)this.getType()) + ")";
            }

            @Generated
            public static class CompoundFilterBuilder {
                @Generated
                private ArrayList<Filter> filters;
                @Generated
                private LogicalOperator type;

                @Generated
                CompoundFilterBuilder() {
                }

                @Generated
                public CompoundFilterBuilder filter(Filter filter) {
                    if (this.filters == null) {
                        this.filters = new ArrayList();
                    }
                    this.filters.add(filter);
                    return this;
                }

                @JsonDeserialize(contentUsing=FilterDeserializer.class)
                @Generated
                public CompoundFilterBuilder filters(Collection<? extends Filter> filters) {
                    if (filters == null) {
                        throw new NullPointerException("filters cannot be null");
                    }
                    if (this.filters == null) {
                        this.filters = new ArrayList();
                    }
                    this.filters.addAll(filters);
                    return this;
                }

                @Generated
                public CompoundFilterBuilder clearFilters() {
                    if (this.filters != null) {
                        this.filters.clear();
                    }
                    return this;
                }

                @Generated
                public CompoundFilterBuilder type(LogicalOperator type) {
                    this.type = type;
                    return this;
                }

                @Generated
                public CompoundFilter build() {
                    List<Filter> filters;
                    switch (this.filters == null ? 0 : this.filters.size()) {
                        case 0: {
                            filters = Collections.emptyList();
                            break;
                        }
                        case 1: {
                            filters = Collections.singletonList(this.filters.get(0));
                            break;
                        }
                        default: {
                            filters = Collections.unmodifiableList(new ArrayList<Filter>(this.filters));
                        }
                    }
                    return new CompoundFilter(filters, this.type);
                }

                @Generated
                public String toString() {
                    return "ResponseTool.Filter.CompoundFilter.CompoundFilterBuilder(filters=" + String.valueOf(this.filters) + ", type=" + String.valueOf((Object)this.type) + ")";
                }
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class ComparisonFilter
        implements Filter {
            @Required
            private String key;
            @Required
            private ComparisonOperator type;
            @Required
            @ObjectType.List(value={@ObjectType(baseClass=String.class), @ObjectType(baseClass=Double.class), @ObjectType(baseClass=Boolean.class)})
            private Object value;

            @Generated
            public static ComparisonFilterBuilder builder() {
                return new ComparisonFilterBuilder();
            }

            @Generated
            public ComparisonFilter(String key, ComparisonOperator type, Object value) {
                this.key = key;
                this.type = type;
                this.value = value;
            }

            @Generated
            public ComparisonFilter() {
            }

            @Generated
            public String getKey() {
                return this.key;
            }

            @Generated
            public ComparisonOperator getType() {
                return this.type;
            }

            @Generated
            public Object getValue() {
                return this.value;
            }

            @Generated
            public String toString() {
                return "ResponseTool.Filter.ComparisonFilter(key=" + this.getKey() + ", type=" + String.valueOf((Object)this.getType()) + ", value=" + String.valueOf(this.getValue()) + ")";
            }

            @Generated
            public static class ComparisonFilterBuilder {
                @Generated
                private String key;
                @Generated
                private ComparisonOperator type;
                @Generated
                private Object value;

                @Generated
                ComparisonFilterBuilder() {
                }

                @Generated
                public ComparisonFilterBuilder key(String key) {
                    this.key = key;
                    return this;
                }

                @Generated
                public ComparisonFilterBuilder type(ComparisonOperator type) {
                    this.type = type;
                    return this;
                }

                @Generated
                public ComparisonFilterBuilder value(Object value) {
                    this.value = value;
                    return this;
                }

                @Generated
                public ComparisonFilter build() {
                    return new ComparisonFilter(this.key, this.type, this.value);
                }

                @Generated
                public String toString() {
                    return "ResponseTool.Filter.ComparisonFilter.ComparisonFilterBuilder(key=" + this.key + ", type=" + String.valueOf((Object)this.type) + ", value=" + String.valueOf(this.value) + ")";
                }
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class LocalShellResponseTool
    extends ResponseTool {
        public static LocalShellResponseTool of() {
            LocalShellResponseTool localShellTool = new LocalShellResponseTool();
            localShellTool.setType(ResponseToolType.LOCAL_SHELL);
            return localShellTool;
        }

        @Generated
        public LocalShellResponseTool() {
        }

        @Generated
        public String toString() {
            return "ResponseTool.LocalShellResponseTool()";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class ImageGenerationResponseTool
    extends ResponseTool {
        private ImageBackground background;
        private ImageMask inputImageMask;
        private String model;
        private String moderation;
        private Integer outputCompression;
        private ImageFormat outputFormat;
        private Integer partialImages;
        private ImageQuality quality;
        private String size;

        public ImageGenerationResponseTool(ImageBackground background, ImageMask inputImageMask, String model, String moderation, Integer outputCompression, ImageFormat outputFormat, Integer partialImages, ImageQuality quality, String size) {
            this.background = background;
            this.inputImageMask = inputImageMask;
            this.model = model;
            this.moderation = moderation;
            this.outputCompression = outputCompression;
            this.outputFormat = outputFormat;
            this.partialImages = partialImages;
            this.quality = quality;
            this.size = size;
            this.type = ResponseToolType.IMAGE_GENERATION;
        }

        @Generated
        public static ImageGenerationResponseToolBuilder builder() {
            return new ImageGenerationResponseToolBuilder();
        }

        @Generated
        public ImageGenerationResponseTool() {
        }

        @Generated
        public ImageBackground getBackground() {
            return this.background;
        }

        @Generated
        public ImageMask getInputImageMask() {
            return this.inputImageMask;
        }

        @Generated
        public String getModel() {
            return this.model;
        }

        @Generated
        public String getModeration() {
            return this.moderation;
        }

        @Generated
        public Integer getOutputCompression() {
            return this.outputCompression;
        }

        @Generated
        public ImageFormat getOutputFormat() {
            return this.outputFormat;
        }

        @Generated
        public Integer getPartialImages() {
            return this.partialImages;
        }

        @Generated
        public ImageQuality getQuality() {
            return this.quality;
        }

        @Generated
        public String getSize() {
            return this.size;
        }

        @Generated
        public String toString() {
            return "ResponseTool.ImageGenerationResponseTool(background=" + String.valueOf((Object)this.getBackground()) + ", inputImageMask=" + String.valueOf(this.getInputImageMask()) + ", model=" + this.getModel() + ", moderation=" + this.getModeration() + ", outputCompression=" + this.getOutputCompression() + ", outputFormat=" + String.valueOf((Object)this.getOutputFormat()) + ", partialImages=" + this.getPartialImages() + ", quality=" + String.valueOf((Object)this.getQuality()) + ", size=" + this.getSize() + ")";
        }

        @Generated
        public static class ImageGenerationResponseToolBuilder {
            @Generated
            private ImageBackground background;
            @Generated
            private ImageMask inputImageMask;
            @Generated
            private String model;
            @Generated
            private String moderation;
            @Generated
            private Integer outputCompression;
            @Generated
            private ImageFormat outputFormat;
            @Generated
            private Integer partialImages;
            @Generated
            private ImageQuality quality;
            @Generated
            private String size;

            @Generated
            ImageGenerationResponseToolBuilder() {
            }

            @Generated
            public ImageGenerationResponseToolBuilder background(ImageBackground background) {
                this.background = background;
                return this;
            }

            @Generated
            public ImageGenerationResponseToolBuilder inputImageMask(ImageMask inputImageMask) {
                this.inputImageMask = inputImageMask;
                return this;
            }

            @Generated
            public ImageGenerationResponseToolBuilder model(String model) {
                this.model = model;
                return this;
            }

            @Generated
            public ImageGenerationResponseToolBuilder moderation(String moderation) {
                this.moderation = moderation;
                return this;
            }

            @Generated
            public ImageGenerationResponseToolBuilder outputCompression(Integer outputCompression) {
                this.outputCompression = outputCompression;
                return this;
            }

            @Generated
            public ImageGenerationResponseToolBuilder outputFormat(ImageFormat outputFormat) {
                this.outputFormat = outputFormat;
                return this;
            }

            @Generated
            public ImageGenerationResponseToolBuilder partialImages(Integer partialImages) {
                this.partialImages = partialImages;
                return this;
            }

            @Generated
            public ImageGenerationResponseToolBuilder quality(ImageQuality quality) {
                this.quality = quality;
                return this;
            }

            @Generated
            public ImageGenerationResponseToolBuilder size(String size) {
                this.size = size;
                return this;
            }

            @Generated
            public ImageGenerationResponseTool build() {
                return new ImageGenerationResponseTool(this.background, this.inputImageMask, this.model, this.moderation, this.outputCompression, this.outputFormat, this.partialImages, this.quality, this.size);
            }

            @Generated
            public String toString() {
                return "ResponseTool.ImageGenerationResponseTool.ImageGenerationResponseToolBuilder(background=" + String.valueOf((Object)this.background) + ", inputImageMask=" + String.valueOf(this.inputImageMask) + ", model=" + this.model + ", moderation=" + this.moderation + ", outputCompression=" + this.outputCompression + ", outputFormat=" + String.valueOf((Object)this.outputFormat) + ", partialImages=" + this.partialImages + ", quality=" + String.valueOf((Object)this.quality) + ", size=" + this.size + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class CodeInterpreterResponseTool
    extends ResponseTool {
        @Required
        @ObjectType.List(value={@ObjectType(baseClass=String.class), @ObjectType(baseClass=ContainerAuto.class)})
        @JsonDeserialize(using=ContainerDeserializer.class)
        private Object container;

        private CodeInterpreterResponseTool(Object container) {
            this.container = container;
            this.type = ResponseToolType.CODE_INTERPRETER;
        }

        public static CodeInterpreterResponseTool of(Object container) {
            return new CodeInterpreterResponseTool(container);
        }

        @Generated
        public CodeInterpreterResponseTool() {
        }

        @Generated
        public Object getContainer() {
            return this.container;
        }

        @Generated
        public String toString() {
            return "ResponseTool.CodeInterpreterResponseTool(container=" + String.valueOf(this.getContainer()) + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class McpResponseTool
    extends ResponseTool {
        @Required
        private String serverLabel;
        @Required
        private String serverUrl;
        @ObjectType.List(value={@ObjectType(baseClass=String.class, firstGroup=true), @ObjectType(baseClass=McpListTools.class)})
        @JsonDeserialize(using=AllowedToolsDeserializer.class)
        private Object allowedTools;
        private Map<String, String> headers;
        @ObjectType.List(value={@ObjectType(baseClass=McpToolApprovalSetting.class), @ObjectType(baseClass=McpToolApprovalFilter.class)})
        @JsonDeserialize(using=RequireApprovalDeserializer.class)
        private Object requireApproval;

        public McpResponseTool(String serverLabel, String serverUrl, Object allowedTools, Map<String, String> headers, Object requireApproval) {
            this.serverLabel = serverLabel;
            this.serverUrl = serverUrl;
            this.allowedTools = allowedTools;
            this.headers = headers;
            this.requireApproval = requireApproval;
            this.type = ResponseToolType.MCP;
        }

        @Generated
        public static McpResponseToolBuilder builder() {
            return new McpResponseToolBuilder();
        }

        @Generated
        public McpResponseTool() {
        }

        @Generated
        public String getServerLabel() {
            return this.serverLabel;
        }

        @Generated
        public String getServerUrl() {
            return this.serverUrl;
        }

        @Generated
        public Object getAllowedTools() {
            return this.allowedTools;
        }

        @Generated
        public Map<String, String> getHeaders() {
            return this.headers;
        }

        @Generated
        public Object getRequireApproval() {
            return this.requireApproval;
        }

        @Generated
        public String toString() {
            return "ResponseTool.McpResponseTool(serverLabel=" + this.getServerLabel() + ", serverUrl=" + this.getServerUrl() + ", allowedTools=" + String.valueOf(this.getAllowedTools()) + ", headers=" + String.valueOf(this.getHeaders()) + ", requireApproval=" + String.valueOf(this.getRequireApproval()) + ")";
        }

        @Generated
        public static class McpResponseToolBuilder {
            @Generated
            private String serverLabel;
            @Generated
            private String serverUrl;
            @Generated
            private Object allowedTools;
            @Generated
            private Map<String, String> headers;
            @Generated
            private Object requireApproval;

            @Generated
            McpResponseToolBuilder() {
            }

            @Generated
            public McpResponseToolBuilder serverLabel(String serverLabel) {
                this.serverLabel = serverLabel;
                return this;
            }

            @Generated
            public McpResponseToolBuilder serverUrl(String serverUrl) {
                this.serverUrl = serverUrl;
                return this;
            }

            @Generated
            public McpResponseToolBuilder allowedTools(Object allowedTools) {
                this.allowedTools = allowedTools;
                return this;
            }

            @Generated
            public McpResponseToolBuilder headers(Map<String, String> headers) {
                this.headers = headers;
                return this;
            }

            @Generated
            public McpResponseToolBuilder requireApproval(Object requireApproval) {
                this.requireApproval = requireApproval;
                return this;
            }

            @Generated
            public McpResponseTool build() {
                return new McpResponseTool(this.serverLabel, this.serverUrl, this.allowedTools, this.headers, this.requireApproval);
            }

            @Generated
            public String toString() {
                return "ResponseTool.McpResponseTool.McpResponseToolBuilder(serverLabel=" + this.serverLabel + ", serverUrl=" + this.serverUrl + ", allowedTools=" + String.valueOf(this.allowedTools) + ", headers=" + String.valueOf(this.headers) + ", requireApproval=" + String.valueOf(this.requireApproval) + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class WebSearchResponseTool
    extends ResponseTool {
        private ContextSize searchContextSize;
        private Location userLocation;

        public WebSearchResponseTool(ContextSize searchContextSize, Location userLocation) {
            this.searchContextSize = searchContextSize;
            this.userLocation = userLocation;
            this.type = ResponseToolType.WEB_SEARCH_PREVIEW;
        }

        public static WebSearchResponseTool of() {
            return WebSearchResponseTool.builder().build();
        }

        @Generated
        public static WebSearchResponseToolBuilder builder() {
            return new WebSearchResponseToolBuilder();
        }

        @Generated
        public WebSearchResponseTool() {
        }

        @Generated
        public ContextSize getSearchContextSize() {
            return this.searchContextSize;
        }

        @Generated
        public Location getUserLocation() {
            return this.userLocation;
        }

        @Generated
        public String toString() {
            return "ResponseTool.WebSearchResponseTool(searchContextSize=" + String.valueOf((Object)this.getSearchContextSize()) + ", userLocation=" + String.valueOf(this.getUserLocation()) + ")";
        }

        @Generated
        public static class WebSearchResponseToolBuilder {
            @Generated
            private ContextSize searchContextSize;
            @Generated
            private Location userLocation;

            @Generated
            WebSearchResponseToolBuilder() {
            }

            @Generated
            public WebSearchResponseToolBuilder searchContextSize(ContextSize searchContextSize) {
                this.searchContextSize = searchContextSize;
                return this;
            }

            @Generated
            public WebSearchResponseToolBuilder userLocation(Location userLocation) {
                this.userLocation = userLocation;
                return this;
            }

            @Generated
            public WebSearchResponseTool build() {
                return new WebSearchResponseTool(this.searchContextSize, this.userLocation);
            }

            @Generated
            public String toString() {
                return "ResponseTool.WebSearchResponseTool.WebSearchResponseToolBuilder(searchContextSize=" + String.valueOf((Object)this.searchContextSize) + ", userLocation=" + String.valueOf(this.userLocation) + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class ComputerResponseTool
    extends ResponseTool {
        @Required
        private Integer displayHeight;
        @Required
        private Integer displayWidth;
        @Required
        private Environment environment;

        public ComputerResponseTool(Integer displayHeight, Integer displayWidth, Environment environment) {
            this.displayHeight = displayHeight;
            this.displayWidth = displayWidth;
            this.environment = environment;
            this.type = ResponseToolType.COMPUTER_USE_PREVIEW;
        }

        @Generated
        public static ComputerResponseToolBuilder builder() {
            return new ComputerResponseToolBuilder();
        }

        @Generated
        public ComputerResponseTool() {
        }

        @Generated
        public Integer getDisplayHeight() {
            return this.displayHeight;
        }

        @Generated
        public Integer getDisplayWidth() {
            return this.displayWidth;
        }

        @Generated
        public Environment getEnvironment() {
            return this.environment;
        }

        @Generated
        public String toString() {
            return "ResponseTool.ComputerResponseTool(displayHeight=" + this.getDisplayHeight() + ", displayWidth=" + this.getDisplayWidth() + ", environment=" + String.valueOf((Object)this.getEnvironment()) + ")";
        }

        @Generated
        public static class ComputerResponseToolBuilder {
            @Generated
            private Integer displayHeight;
            @Generated
            private Integer displayWidth;
            @Generated
            private Environment environment;

            @Generated
            ComputerResponseToolBuilder() {
            }

            @Generated
            public ComputerResponseToolBuilder displayHeight(Integer displayHeight) {
                this.displayHeight = displayHeight;
                return this;
            }

            @Generated
            public ComputerResponseToolBuilder displayWidth(Integer displayWidth) {
                this.displayWidth = displayWidth;
                return this;
            }

            @Generated
            public ComputerResponseToolBuilder environment(Environment environment) {
                this.environment = environment;
                return this;
            }

            @Generated
            public ComputerResponseTool build() {
                return new ComputerResponseTool(this.displayHeight, this.displayWidth, this.environment);
            }

            @Generated
            public String toString() {
                return "ResponseTool.ComputerResponseTool.ComputerResponseToolBuilder(displayHeight=" + this.displayHeight + ", displayWidth=" + this.displayWidth + ", environment=" + String.valueOf((Object)this.environment) + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class FunctionResponseTool
    extends ResponseTool {
        @Required
        private String name;
        @Required
        private JsonNode parameters;
        @Required
        private Boolean strict;
        private String description;

        public static FunctionResponseTool function(FunctionDef funcDef) {
            FunctionResponseTool funcTool = new FunctionResponseTool(funcDef.getName(), funcDef.getSchemaConverter().convert(funcDef.getFunctionalClass()), funcDef.getStrict(), funcDef.getDescription());
            funcTool.setType(ResponseToolType.FUNCTION);
            return funcTool;
        }

        public static List<FunctionResponseTool> functions(List<FunctionDef> funcDefList) {
            return funcDefList.stream().map(FunctionResponseTool::function).collect(Collectors.toList());
        }

        @Generated
        public FunctionResponseTool(String name, JsonNode parameters, Boolean strict, String description) {
            this.name = name;
            this.parameters = parameters;
            this.strict = strict;
            this.description = description;
        }

        @Generated
        public FunctionResponseTool() {
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public JsonNode getParameters() {
            return this.parameters;
        }

        @Generated
        public Boolean getStrict() {
            return this.strict;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public String toString() {
            return "ResponseTool.FunctionResponseTool(name=" + this.getName() + ", parameters=" + String.valueOf(this.getParameters()) + ", strict=" + this.getStrict() + ", description=" + this.getDescription() + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class FileSearchResponseTool
    extends ResponseTool {
        @Required
        private List<String> vectorStoreIds;
        @JsonDeserialize(using=FilterDeserializer.class)
        private Filter filters;
        @Range(min=1.0, max=50.0)
        private Integer maxNumResults;
        private RankingOption rankingOptions;

        public FileSearchResponseTool(List<String> vectorStoreIds, Filter filters, Integer maxNumResults, RankingOption rankingOptions) {
            this.vectorStoreIds = vectorStoreIds;
            this.filters = filters;
            this.maxNumResults = maxNumResults;
            this.rankingOptions = rankingOptions;
            this.type = ResponseToolType.FILE_SEARCH;
        }

        public static FileSearchResponseTool of(List<String> vectorStoreIds) {
            return FileSearchResponseTool.builder().vectorStoreIds(vectorStoreIds).build();
        }

        @Generated
        public static FileSearchResponseToolBuilder builder() {
            return new FileSearchResponseToolBuilder();
        }

        @Generated
        public FileSearchResponseTool() {
        }

        @Generated
        public List<String> getVectorStoreIds() {
            return this.vectorStoreIds;
        }

        @Generated
        public Filter getFilters() {
            return this.filters;
        }

        @Generated
        public Integer getMaxNumResults() {
            return this.maxNumResults;
        }

        @Generated
        public RankingOption getRankingOptions() {
            return this.rankingOptions;
        }

        @Generated
        public String toString() {
            return "ResponseTool.FileSearchResponseTool(vectorStoreIds=" + String.valueOf(this.getVectorStoreIds()) + ", filters=" + String.valueOf(this.getFilters()) + ", maxNumResults=" + this.getMaxNumResults() + ", rankingOptions=" + String.valueOf(this.getRankingOptions()) + ")";
        }

        @Generated
        public static class FileSearchResponseToolBuilder {
            @Generated
            private List<String> vectorStoreIds;
            @Generated
            private Filter filters;
            @Generated
            private Integer maxNumResults;
            @Generated
            private RankingOption rankingOptions;

            @Generated
            FileSearchResponseToolBuilder() {
            }

            @Generated
            public FileSearchResponseToolBuilder vectorStoreIds(List<String> vectorStoreIds) {
                this.vectorStoreIds = vectorStoreIds;
                return this;
            }

            @Generated
            public FileSearchResponseToolBuilder filters(Filter filters) {
                this.filters = filters;
                return this;
            }

            @Generated
            public FileSearchResponseToolBuilder maxNumResults(Integer maxNumResults) {
                this.maxNumResults = maxNumResults;
                return this;
            }

            @Generated
            public FileSearchResponseToolBuilder rankingOptions(RankingOption rankingOptions) {
                this.rankingOptions = rankingOptions;
                return this;
            }

            @Generated
            public FileSearchResponseTool build() {
                return new FileSearchResponseTool(this.vectorStoreIds, this.filters, this.maxNumResults, this.rankingOptions);
            }

            @Generated
            public String toString() {
                return "ResponseTool.FileSearchResponseTool.FileSearchResponseToolBuilder(vectorStoreIds=" + String.valueOf(this.vectorStoreIds) + ", filters=" + String.valueOf(this.filters) + ", maxNumResults=" + this.maxNumResults + ", rankingOptions=" + String.valueOf(this.rankingOptions) + ")";
            }
        }
    }
}

