/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.response;

import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.domain.chat.ChatRequest;
import io.github.sashirestela.openai.domain.response.Input;
import io.github.sashirestela.openai.domain.response.ItemDeserializer;
import io.github.sashirestela.openai.domain.response.Reasoning;
import io.github.sashirestela.openai.domain.response.ResponseRequest;
import io.github.sashirestela.openai.domain.response.ResponseText;
import io.github.sashirestela.openai.domain.response.ResponseTool;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class Response {
    private Boolean background;
    private Long createdAt;
    private ResponseError error;
    private String id;
    private IncompleteDetails incompleteDetails;
    private String instructions;
    private Long maxOutputTokens;
    private Map<String, String> metadata;
    private String model;
    private String object;
    @JsonDeserialize(contentUsing=ItemDeserializer.class)
    private List<Input.Item> output;
    private Boolean parallelToolCalls;
    private String previousResponseId;
    private Reasoning reasoning;
    private ChatRequest.ServiceTier serviceTier;
    private ResponseStatus status;
    private Double temperature;
    private ResponseText text;
    private Object toolChoice;
    private List<ResponseTool> tools;
    private Double topP;
    private ResponseRequest.Truncation truncation;
    private ResponseUsage usage;
    private String user;

    public String outputText() {
        return this.output.stream().filter(item -> item instanceof Input.Item.OutputMessageItem).filter(item -> ((Input.Item.OutputMessageItem)item).getContent() != null).flatMap(item -> ((Input.Item.OutputMessageItem)item).getContent().stream()).filter(content -> content instanceof Input.OutputContent.TextOutputContent).map(content -> ((Input.OutputContent.TextOutputContent)content).getText()).collect(Collectors.joining());
    }

    @Generated
    public Response() {
    }

    @Generated
    public Boolean getBackground() {
        return this.background;
    }

    @Generated
    public Long getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public ResponseError getError() {
        return this.error;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public IncompleteDetails getIncompleteDetails() {
        return this.incompleteDetails;
    }

    @Generated
    public String getInstructions() {
        return this.instructions;
    }

    @Generated
    public Long getMaxOutputTokens() {
        return this.maxOutputTokens;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public List<Input.Item> getOutput() {
        return this.output;
    }

    @Generated
    public Boolean getParallelToolCalls() {
        return this.parallelToolCalls;
    }

    @Generated
    public String getPreviousResponseId() {
        return this.previousResponseId;
    }

    @Generated
    public Reasoning getReasoning() {
        return this.reasoning;
    }

    @Generated
    public ChatRequest.ServiceTier getServiceTier() {
        return this.serviceTier;
    }

    @Generated
    public ResponseStatus getStatus() {
        return this.status;
    }

    @Generated
    public Double getTemperature() {
        return this.temperature;
    }

    @Generated
    public ResponseText getText() {
        return this.text;
    }

    @Generated
    public Object getToolChoice() {
        return this.toolChoice;
    }

    @Generated
    public List<ResponseTool> getTools() {
        return this.tools;
    }

    @Generated
    public Double getTopP() {
        return this.topP;
    }

    @Generated
    public ResponseRequest.Truncation getTruncation() {
        return this.truncation;
    }

    @Generated
    public ResponseUsage getUsage() {
        return this.usage;
    }

    @Generated
    public String getUser() {
        return this.user;
    }

    @Generated
    public String toString() {
        return "Response(background=" + this.getBackground() + ", createdAt=" + this.getCreatedAt() + ", error=" + String.valueOf(this.getError()) + ", id=" + this.getId() + ", incompleteDetails=" + String.valueOf(this.getIncompleteDetails()) + ", instructions=" + this.getInstructions() + ", maxOutputTokens=" + this.getMaxOutputTokens() + ", metadata=" + String.valueOf(this.getMetadata()) + ", model=" + this.getModel() + ", object=" + this.getObject() + ", output=" + String.valueOf(this.getOutput()) + ", parallelToolCalls=" + this.getParallelToolCalls() + ", previousResponseId=" + this.getPreviousResponseId() + ", reasoning=" + String.valueOf(this.getReasoning()) + ", serviceTier=" + String.valueOf((Object)this.getServiceTier()) + ", status=" + String.valueOf((Object)this.getStatus()) + ", temperature=" + this.getTemperature() + ", text=" + String.valueOf(this.getText()) + ", toolChoice=" + String.valueOf(this.getToolChoice()) + ", tools=" + String.valueOf(this.getTools()) + ", topP=" + this.getTopP() + ", truncation=" + String.valueOf((Object)this.getTruncation()) + ", usage=" + String.valueOf(this.getUsage()) + ", user=" + this.getUser() + ")";
    }

    public static enum ResponseStatus {
        COMPLETED,
        FAILED,
        IN_PROGRESS,
        CANCELLED,
        QUEUED,
        INCOMPLETE;

    }

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class ResponseUsage {
        private Integer inputTokens;
        private InputTokenDetails inputTokenDetails;
        private Integer outputTokens;
        private OutputTokenDetails outputTokenDetails;
        private Integer totalTokens;

        @Generated
        public ResponseUsage() {
        }

        @Generated
        public Integer getInputTokens() {
            return this.inputTokens;
        }

        @Generated
        public InputTokenDetails getInputTokenDetails() {
            return this.inputTokenDetails;
        }

        @Generated
        public Integer getOutputTokens() {
            return this.outputTokens;
        }

        @Generated
        public OutputTokenDetails getOutputTokenDetails() {
            return this.outputTokenDetails;
        }

        @Generated
        public Integer getTotalTokens() {
            return this.totalTokens;
        }

        @Generated
        public String toString() {
            return "Response.ResponseUsage(inputTokens=" + this.getInputTokens() + ", inputTokenDetails=" + String.valueOf(this.getInputTokenDetails()) + ", outputTokens=" + this.getOutputTokens() + ", outputTokenDetails=" + String.valueOf(this.getOutputTokenDetails()) + ", totalTokens=" + this.getTotalTokens() + ")";
        }

        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class OutputTokenDetails {
            private Integer reasoningTokens;

            @Generated
            public OutputTokenDetails() {
            }

            @Generated
            public Integer getReasoningTokens() {
                return this.reasoningTokens;
            }

            @Generated
            public String toString() {
                return "Response.ResponseUsage.OutputTokenDetails(reasoningTokens=" + this.getReasoningTokens() + ")";
            }
        }

        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class InputTokenDetails {
            private Integer cachedTokens;

            @Generated
            public InputTokenDetails() {
            }

            @Generated
            public Integer getCachedTokens() {
                return this.cachedTokens;
            }

            @Generated
            public String toString() {
                return "Response.ResponseUsage.InputTokenDetails(cachedTokens=" + this.getCachedTokens() + ")";
            }
        }
    }

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class IncompleteDetails {
        private String reason;

        @Generated
        public IncompleteDetails() {
        }

        @Generated
        public String getReason() {
            return this.reason;
        }

        @Generated
        public String toString() {
            return "Response.IncompleteDetails(reason=" + this.getReason() + ")";
        }
    }

    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class ResponseError {
        private String code;
        private String message;

        @Generated
        public ResponseError() {
        }

        @Generated
        public String getCode() {
            return this.code;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public String toString() {
            return "Response.ResponseError(code=" + this.getCode() + ", message=" + this.getMessage() + ")";
        }
    }
}

