/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.assistant;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.common.ResponseFormat;
import io.github.sashirestela.openai.common.tool.Tool;
import io.github.sashirestela.openai.domain.assistant.ToolResource;
import io.github.sashirestela.slimvalidator.constraints.ObjectType;
import io.github.sashirestela.slimvalidator.constraints.Range;
import io.github.sashirestela.slimvalidator.constraints.Size;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class AssistantModifyRequest {
    private String model;
    @Size(max=256)
    private String name;
    @Size(max=512)
    private String description;
    @Size(max=256000)
    private String instructions;
    @Size(max=128)
    private List<Tool> tools;
    private ToolResource toolResources;
    @Size(max=16)
    private Map<String, String> metadata;
    @Range(min=0.0, max=2.0)
    private Double temperature;
    @Range(min=0.0, max=1.0)
    private Double topP;
    @ObjectType.List(value={@ObjectType(baseClass=String.class), @ObjectType(baseClass=ResponseFormat.class)})
    private Object responseFormat;

    @Generated
    AssistantModifyRequest(String model, String name, String description, String instructions, List<Tool> tools, ToolResource toolResources, Map<String, String> metadata, Double temperature, Double topP, Object responseFormat) {
        this.model = model;
        this.name = name;
        this.description = description;
        this.instructions = instructions;
        this.tools = tools;
        this.toolResources = toolResources;
        this.metadata = metadata;
        this.temperature = temperature;
        this.topP = topP;
        this.responseFormat = responseFormat;
    }

    @Generated
    public static AssistantModifyRequestBuilder builder() {
        return new AssistantModifyRequestBuilder();
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getInstructions() {
        return this.instructions;
    }

    @Generated
    public List<Tool> getTools() {
        return this.tools;
    }

    @Generated
    public ToolResource getToolResources() {
        return this.toolResources;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public Double getTemperature() {
        return this.temperature;
    }

    @Generated
    public Double getTopP() {
        return this.topP;
    }

    @Generated
    public Object getResponseFormat() {
        return this.responseFormat;
    }

    @Generated
    public static class AssistantModifyRequestBuilder {
        @Generated
        private String model;
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private String instructions;
        @Generated
        private ArrayList<Tool> tools;
        @Generated
        private ToolResource toolResources;
        @Generated
        private Map<String, String> metadata;
        @Generated
        private Double temperature;
        @Generated
        private Double topP;
        @Generated
        private Object responseFormat;

        @Generated
        AssistantModifyRequestBuilder() {
        }

        @Generated
        public AssistantModifyRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        @Generated
        public AssistantModifyRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public AssistantModifyRequestBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public AssistantModifyRequestBuilder instructions(String instructions) {
            this.instructions = instructions;
            return this;
        }

        @Generated
        public AssistantModifyRequestBuilder tool(Tool tool) {
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.add(tool);
            return this;
        }

        @Generated
        public AssistantModifyRequestBuilder tools(Collection<? extends Tool> tools) {
            if (tools == null) {
                throw new NullPointerException("tools cannot be null");
            }
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.addAll(tools);
            return this;
        }

        @Generated
        public AssistantModifyRequestBuilder clearTools() {
            if (this.tools != null) {
                this.tools.clear();
            }
            return this;
        }

        @Generated
        public AssistantModifyRequestBuilder toolResources(ToolResource toolResources) {
            this.toolResources = toolResources;
            return this;
        }

        @Generated
        public AssistantModifyRequestBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        @Generated
        public AssistantModifyRequestBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        @Generated
        public AssistantModifyRequestBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        @Generated
        public AssistantModifyRequestBuilder responseFormat(Object responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        @Generated
        public AssistantModifyRequest build() {
            List<Tool> tools;
            switch (this.tools == null ? 0 : this.tools.size()) {
                case 0: {
                    tools = Collections.emptyList();
                    break;
                }
                case 1: {
                    tools = Collections.singletonList(this.tools.get(0));
                    break;
                }
                default: {
                    tools = Collections.unmodifiableList(new ArrayList<Tool>(this.tools));
                }
            }
            return new AssistantModifyRequest(this.model, this.name, this.description, this.instructions, tools, this.toolResources, this.metadata, this.temperature, this.topP, this.responseFormat);
        }

        @Generated
        public String toString() {
            return "AssistantModifyRequest.AssistantModifyRequestBuilder(model=" + this.model + ", name=" + this.name + ", description=" + this.description + ", instructions=" + this.instructions + ", tools=" + String.valueOf(this.tools) + ", toolResources=" + String.valueOf(this.toolResources) + ", metadata=" + String.valueOf(this.metadata) + ", temperature=" + this.temperature + ", topP=" + this.topP + ", responseFormat=" + String.valueOf(this.responseFormat) + ")";
        }
    }
}

