/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.response;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.common.function.FunctionDef;
import io.github.sashirestela.openai.domain.assistant.RankingOption;
import io.github.sashirestela.openai.domain.response.FilterDeserializer;
import io.github.sashirestela.slimvalidator.constraints.ObjectType;
import io.github.sashirestela.slimvalidator.constraints.Range;
import io.github.sashirestela.slimvalidator.constraints.Required;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=FileSearchResponseTool.class, name="file_search"), @JsonSubTypes.Type(value=FunctionResponseTool.class, name="function"), @JsonSubTypes.Type(value=ComputerResponseTool.class, name="computer_use_preview"), @JsonSubTypes.Type(value=WebSearchResponseTool.class, name="web_search_preview")})
public abstract class ResponseTool {
    protected ResponseToolType type;

    @Generated
    public ResponseToolType getType() {
        return this.type;
    }

    @Generated
    public void setType(ResponseToolType type) {
        this.type = type;
    }

    public static enum ContextSize {
        LOW,
        MEDIUM,
        HIGH;

    }

    public static enum Environment {
        MAC,
        WINDOWS,
        UBUNTU,
        BROWSER;

    }

    public static enum LogicalOperator {
        AND,
        OR;

    }

    public static enum ComparisonOperator {
        EQ,
        NE,
        GT,
        GTE,
        LT,
        LTE;

    }

    public static enum ResponseToolType {
        FILE_SEARCH,
        FUNCTION,
        COMPUTER_USE_PREVIEW,
        WEB_SEARCH_PREVIEW;

    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class Location {
        private String type;
        private String city;
        private String country;
        private String region;
        private String timezone;

        public Location(String type, String city, String country, String region, String timezone) {
            this.type = "approximate";
            this.city = city;
            this.country = country;
            this.region = region;
            this.timezone = timezone;
        }

        @Generated
        public static LocationBuilder builder() {
            return new LocationBuilder();
        }

        @Generated
        public Location() {
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getCity() {
            return this.city;
        }

        @Generated
        public String getCountry() {
            return this.country;
        }

        @Generated
        public String getRegion() {
            return this.region;
        }

        @Generated
        public String getTimezone() {
            return this.timezone;
        }

        @Generated
        public String toString() {
            return "ResponseTool.Location(type=" + this.getType() + ", city=" + this.getCity() + ", country=" + this.getCountry() + ", region=" + this.getRegion() + ", timezone=" + this.getTimezone() + ")";
        }

        @Generated
        public static class LocationBuilder {
            @Generated
            private String type;
            @Generated
            private String city;
            @Generated
            private String country;
            @Generated
            private String region;
            @Generated
            private String timezone;

            @Generated
            LocationBuilder() {
            }

            @Generated
            public LocationBuilder type(String type) {
                this.type = type;
                return this;
            }

            @Generated
            public LocationBuilder city(String city) {
                this.city = city;
                return this;
            }

            @Generated
            public LocationBuilder country(String country) {
                this.country = country;
                return this;
            }

            @Generated
            public LocationBuilder region(String region) {
                this.region = region;
                return this;
            }

            @Generated
            public LocationBuilder timezone(String timezone) {
                this.timezone = timezone;
                return this;
            }

            @Generated
            public Location build() {
                return new Location(this.type, this.city, this.country, this.region, this.timezone);
            }

            @Generated
            public String toString() {
                return "ResponseTool.Location.LocationBuilder(type=" + this.type + ", city=" + this.city + ", country=" + this.country + ", region=" + this.region + ", timezone=" + this.timezone + ")";
            }
        }
    }

    public static interface Filter {

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class CompoundFilter
        implements Filter {
            @Required
            @JsonDeserialize(contentUsing=FilterDeserializer.class)
            private List<Filter> filters;
            @Required
            private LogicalOperator type;

            @Generated
            public static CompoundFilterBuilder builder() {
                return new CompoundFilterBuilder();
            }

            @Generated
            public CompoundFilter(List<Filter> filters, LogicalOperator type) {
                this.filters = filters;
                this.type = type;
            }

            @Generated
            public CompoundFilter() {
            }

            @Generated
            public List<Filter> getFilters() {
                return this.filters;
            }

            @Generated
            public LogicalOperator getType() {
                return this.type;
            }

            @Generated
            public String toString() {
                return "ResponseTool.Filter.CompoundFilter(filters=" + String.valueOf(this.getFilters()) + ", type=" + String.valueOf((Object)this.getType()) + ")";
            }

            @Generated
            public static class CompoundFilterBuilder {
                @Generated
                private ArrayList<Filter> filters;
                @Generated
                private LogicalOperator type;

                @Generated
                CompoundFilterBuilder() {
                }

                @Generated
                public CompoundFilterBuilder filter(Filter filter) {
                    if (this.filters == null) {
                        this.filters = new ArrayList();
                    }
                    this.filters.add(filter);
                    return this;
                }

                @JsonDeserialize(contentUsing=FilterDeserializer.class)
                @Generated
                public CompoundFilterBuilder filters(Collection<? extends Filter> filters) {
                    if (filters == null) {
                        throw new NullPointerException("filters cannot be null");
                    }
                    if (this.filters == null) {
                        this.filters = new ArrayList();
                    }
                    this.filters.addAll(filters);
                    return this;
                }

                @Generated
                public CompoundFilterBuilder clearFilters() {
                    if (this.filters != null) {
                        this.filters.clear();
                    }
                    return this;
                }

                @Generated
                public CompoundFilterBuilder type(LogicalOperator type) {
                    this.type = type;
                    return this;
                }

                @Generated
                public CompoundFilter build() {
                    List<Filter> filters;
                    switch (this.filters == null ? 0 : this.filters.size()) {
                        case 0: {
                            filters = Collections.emptyList();
                            break;
                        }
                        case 1: {
                            filters = Collections.singletonList(this.filters.get(0));
                            break;
                        }
                        default: {
                            filters = Collections.unmodifiableList(new ArrayList<Filter>(this.filters));
                        }
                    }
                    return new CompoundFilter(filters, this.type);
                }

                @Generated
                public String toString() {
                    return "ResponseTool.Filter.CompoundFilter.CompoundFilterBuilder(filters=" + String.valueOf(this.filters) + ", type=" + String.valueOf((Object)this.type) + ")";
                }
            }
        }

        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
        public static class ComparisonFilter
        implements Filter {
            @Required
            private String key;
            @Required
            private ComparisonOperator type;
            @Required
            @ObjectType.List(value={@ObjectType(baseClass=String.class), @ObjectType(baseClass=Double.class), @ObjectType(baseClass=Boolean.class)})
            private Object value;

            @Generated
            public static ComparisonFilterBuilder builder() {
                return new ComparisonFilterBuilder();
            }

            @Generated
            public ComparisonFilter(String key, ComparisonOperator type, Object value) {
                this.key = key;
                this.type = type;
                this.value = value;
            }

            @Generated
            public ComparisonFilter() {
            }

            @Generated
            public String getKey() {
                return this.key;
            }

            @Generated
            public ComparisonOperator getType() {
                return this.type;
            }

            @Generated
            public Object getValue() {
                return this.value;
            }

            @Generated
            public String toString() {
                return "ResponseTool.Filter.ComparisonFilter(key=" + this.getKey() + ", type=" + String.valueOf((Object)this.getType()) + ", value=" + String.valueOf(this.getValue()) + ")";
            }

            @Generated
            public static class ComparisonFilterBuilder {
                @Generated
                private String key;
                @Generated
                private ComparisonOperator type;
                @Generated
                private Object value;

                @Generated
                ComparisonFilterBuilder() {
                }

                @Generated
                public ComparisonFilterBuilder key(String key) {
                    this.key = key;
                    return this;
                }

                @Generated
                public ComparisonFilterBuilder type(ComparisonOperator type) {
                    this.type = type;
                    return this;
                }

                @Generated
                public ComparisonFilterBuilder value(Object value) {
                    this.value = value;
                    return this;
                }

                @Generated
                public ComparisonFilter build() {
                    return new ComparisonFilter(this.key, this.type, this.value);
                }

                @Generated
                public String toString() {
                    return "ResponseTool.Filter.ComparisonFilter.ComparisonFilterBuilder(key=" + this.key + ", type=" + String.valueOf((Object)this.type) + ", value=" + String.valueOf(this.value) + ")";
                }
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class WebSearchResponseTool
    extends ResponseTool {
        private ContextSize searchContextSize;
        private Location userLocation;

        public WebSearchResponseTool(ContextSize searchContextSize, Location userLocation) {
            this.searchContextSize = searchContextSize;
            this.userLocation = userLocation;
            this.type = ResponseToolType.WEB_SEARCH_PREVIEW;
        }

        public static WebSearchResponseTool of() {
            return WebSearchResponseTool.builder().build();
        }

        @Generated
        public static WebSearchResponseToolBuilder builder() {
            return new WebSearchResponseToolBuilder();
        }

        @Generated
        public WebSearchResponseTool() {
        }

        @Generated
        public ContextSize getSearchContextSize() {
            return this.searchContextSize;
        }

        @Generated
        public Location getUserLocation() {
            return this.userLocation;
        }

        @Generated
        public String toString() {
            return "ResponseTool.WebSearchResponseTool(searchContextSize=" + String.valueOf((Object)this.getSearchContextSize()) + ", userLocation=" + String.valueOf(this.getUserLocation()) + ")";
        }

        @Generated
        public static class WebSearchResponseToolBuilder {
            @Generated
            private ContextSize searchContextSize;
            @Generated
            private Location userLocation;

            @Generated
            WebSearchResponseToolBuilder() {
            }

            @Generated
            public WebSearchResponseToolBuilder searchContextSize(ContextSize searchContextSize) {
                this.searchContextSize = searchContextSize;
                return this;
            }

            @Generated
            public WebSearchResponseToolBuilder userLocation(Location userLocation) {
                this.userLocation = userLocation;
                return this;
            }

            @Generated
            public WebSearchResponseTool build() {
                return new WebSearchResponseTool(this.searchContextSize, this.userLocation);
            }

            @Generated
            public String toString() {
                return "ResponseTool.WebSearchResponseTool.WebSearchResponseToolBuilder(searchContextSize=" + String.valueOf((Object)this.searchContextSize) + ", userLocation=" + String.valueOf(this.userLocation) + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class ComputerResponseTool
    extends ResponseTool {
        @Required
        private Double displayHeight;
        @Required
        private Double displayWidth;
        @Required
        private Environment environment;

        public ComputerResponseTool(Double displayHeight, Double displayWidth, Environment environment) {
            this.displayHeight = displayHeight;
            this.displayWidth = displayWidth;
            this.environment = environment;
            this.type = ResponseToolType.COMPUTER_USE_PREVIEW;
        }

        @Generated
        public static ComputerResponseToolBuilder builder() {
            return new ComputerResponseToolBuilder();
        }

        @Generated
        public ComputerResponseTool() {
        }

        @Generated
        public Double getDisplayHeight() {
            return this.displayHeight;
        }

        @Generated
        public Double getDisplayWidth() {
            return this.displayWidth;
        }

        @Generated
        public Environment getEnvironment() {
            return this.environment;
        }

        @Generated
        public String toString() {
            return "ResponseTool.ComputerResponseTool(displayHeight=" + this.getDisplayHeight() + ", displayWidth=" + this.getDisplayWidth() + ", environment=" + String.valueOf((Object)this.getEnvironment()) + ")";
        }

        @Generated
        public static class ComputerResponseToolBuilder {
            @Generated
            private Double displayHeight;
            @Generated
            private Double displayWidth;
            @Generated
            private Environment environment;

            @Generated
            ComputerResponseToolBuilder() {
            }

            @Generated
            public ComputerResponseToolBuilder displayHeight(Double displayHeight) {
                this.displayHeight = displayHeight;
                return this;
            }

            @Generated
            public ComputerResponseToolBuilder displayWidth(Double displayWidth) {
                this.displayWidth = displayWidth;
                return this;
            }

            @Generated
            public ComputerResponseToolBuilder environment(Environment environment) {
                this.environment = environment;
                return this;
            }

            @Generated
            public ComputerResponseTool build() {
                return new ComputerResponseTool(this.displayHeight, this.displayWidth, this.environment);
            }

            @Generated
            public String toString() {
                return "ResponseTool.ComputerResponseTool.ComputerResponseToolBuilder(displayHeight=" + this.displayHeight + ", displayWidth=" + this.displayWidth + ", environment=" + String.valueOf((Object)this.environment) + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class FunctionResponseTool
    extends ResponseTool {
        @Required
        private String name;
        @Required
        private JsonNode parameters;
        @Required
        private Boolean strict;
        private String description;

        public static FunctionResponseTool function(FunctionDef funcDef) {
            FunctionResponseTool funcTool = new FunctionResponseTool(funcDef.getName(), funcDef.getSchemaConverter().convert(funcDef.getFunctionalClass()), funcDef.getStrict(), funcDef.getDescription());
            funcTool.setType(ResponseToolType.FUNCTION);
            return funcTool;
        }

        public static List<FunctionResponseTool> functions(List<FunctionDef> funcDefList) {
            return funcDefList.stream().map(FunctionResponseTool::function).collect(Collectors.toList());
        }

        @Generated
        public FunctionResponseTool(String name, JsonNode parameters, Boolean strict, String description) {
            this.name = name;
            this.parameters = parameters;
            this.strict = strict;
            this.description = description;
        }

        @Generated
        public FunctionResponseTool() {
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public JsonNode getParameters() {
            return this.parameters;
        }

        @Generated
        public Boolean getStrict() {
            return this.strict;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public String toString() {
            return "ResponseTool.FunctionResponseTool(name=" + this.getName() + ", parameters=" + String.valueOf(this.getParameters()) + ", strict=" + this.getStrict() + ", description=" + this.getDescription() + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class FileSearchResponseTool
    extends ResponseTool {
        @Required
        private List<String> vectorStoreIds;
        @JsonDeserialize(using=FilterDeserializer.class)
        private Filter filters;
        @Range(min=1.0, max=50.0)
        private Integer maxNumResults;
        private RankingOption rankingOptions;

        public FileSearchResponseTool(List<String> vectorStoreIds, Filter filters, Integer maxNumResults, RankingOption rankingOptions) {
            this.vectorStoreIds = vectorStoreIds;
            this.filters = filters;
            this.maxNumResults = maxNumResults;
            this.rankingOptions = rankingOptions;
            this.type = ResponseToolType.FILE_SEARCH;
        }

        public static FileSearchResponseTool of(List<String> vectorStoreIds) {
            return FileSearchResponseTool.builder().vectorStoreIds(vectorStoreIds).build();
        }

        @Generated
        public static FileSearchResponseToolBuilder builder() {
            return new FileSearchResponseToolBuilder();
        }

        @Generated
        public FileSearchResponseTool() {
        }

        @Generated
        public List<String> getVectorStoreIds() {
            return this.vectorStoreIds;
        }

        @Generated
        public Filter getFilters() {
            return this.filters;
        }

        @Generated
        public Integer getMaxNumResults() {
            return this.maxNumResults;
        }

        @Generated
        public RankingOption getRankingOptions() {
            return this.rankingOptions;
        }

        @Generated
        public String toString() {
            return "ResponseTool.FileSearchResponseTool(vectorStoreIds=" + String.valueOf(this.getVectorStoreIds()) + ", filters=" + String.valueOf(this.getFilters()) + ", maxNumResults=" + this.getMaxNumResults() + ", rankingOptions=" + String.valueOf(this.getRankingOptions()) + ")";
        }

        @Generated
        public static class FileSearchResponseToolBuilder {
            @Generated
            private List<String> vectorStoreIds;
            @Generated
            private Filter filters;
            @Generated
            private Integer maxNumResults;
            @Generated
            private RankingOption rankingOptions;

            @Generated
            FileSearchResponseToolBuilder() {
            }

            @Generated
            public FileSearchResponseToolBuilder vectorStoreIds(List<String> vectorStoreIds) {
                this.vectorStoreIds = vectorStoreIds;
                return this;
            }

            @Generated
            public FileSearchResponseToolBuilder filters(Filter filters) {
                this.filters = filters;
                return this;
            }

            @Generated
            public FileSearchResponseToolBuilder maxNumResults(Integer maxNumResults) {
                this.maxNumResults = maxNumResults;
                return this;
            }

            @Generated
            public FileSearchResponseToolBuilder rankingOptions(RankingOption rankingOptions) {
                this.rankingOptions = rankingOptions;
                return this;
            }

            @Generated
            public FileSearchResponseTool build() {
                return new FileSearchResponseTool(this.vectorStoreIds, this.filters, this.maxNumResults, this.rankingOptions);
            }

            @Generated
            public String toString() {
                return "ResponseTool.FileSearchResponseTool.FileSearchResponseToolBuilder(vectorStoreIds=" + String.valueOf(this.vectorStoreIds) + ", filters=" + String.valueOf(this.filters) + ", maxNumResults=" + this.maxNumResults + ", rankingOptions=" + String.valueOf(this.rankingOptions) + ")";
            }
        }
    }
}

