/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.assistant;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.slimvalidator.constraints.Required;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class ThreadRunSubmitOutputRequest {
    @Required
    private List<ToolOutput> toolOutputs;
    private Boolean stream;

    ThreadRunSubmitOutputRequest(List<ToolOutput> toolOutputs, Boolean stream) {
        this.toolOutputs = toolOutputs;
        this.stream = stream;
    }

    public static ThreadRunSubmitOutputRequestBuilder builder() {
        return new ThreadRunSubmitOutputRequestBuilder();
    }

    public List<ToolOutput> getToolOutputs() {
        return this.toolOutputs;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public ThreadRunSubmitOutputRequest withStream(Boolean stream) {
        return this.stream == stream ? this : new ThreadRunSubmitOutputRequest(this.toolOutputs, stream);
    }

    public static class ThreadRunSubmitOutputRequestBuilder {
        private ArrayList<ToolOutput> toolOutputs;
        private Boolean stream;

        ThreadRunSubmitOutputRequestBuilder() {
        }

        public ThreadRunSubmitOutputRequestBuilder toolOutput(ToolOutput toolOutput) {
            if (this.toolOutputs == null) {
                this.toolOutputs = new ArrayList();
            }
            this.toolOutputs.add(toolOutput);
            return this;
        }

        public ThreadRunSubmitOutputRequestBuilder toolOutputs(Collection<? extends ToolOutput> toolOutputs) {
            if (toolOutputs == null) {
                throw new NullPointerException("toolOutputs cannot be null");
            }
            if (this.toolOutputs == null) {
                this.toolOutputs = new ArrayList();
            }
            this.toolOutputs.addAll(toolOutputs);
            return this;
        }

        public ThreadRunSubmitOutputRequestBuilder clearToolOutputs() {
            if (this.toolOutputs != null) {
                this.toolOutputs.clear();
            }
            return this;
        }

        public ThreadRunSubmitOutputRequestBuilder stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        public ThreadRunSubmitOutputRequest build() {
            List<ToolOutput> toolOutputs;
            switch (this.toolOutputs == null ? 0 : this.toolOutputs.size()) {
                case 0: {
                    toolOutputs = Collections.emptyList();
                    break;
                }
                case 1: {
                    toolOutputs = Collections.singletonList(this.toolOutputs.get(0));
                    break;
                }
                default: {
                    toolOutputs = Collections.unmodifiableList(new ArrayList<ToolOutput>(this.toolOutputs));
                }
            }
            return new ThreadRunSubmitOutputRequest(toolOutputs, this.stream);
        }

        public String toString() {
            return "ThreadRunSubmitOutputRequest.ThreadRunSubmitOutputRequestBuilder(toolOutputs=" + this.toolOutputs + ", stream=" + this.stream + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class ToolOutput {
        private String toolCallId;
        private String output;

        ToolOutput(String toolCallId, String output) {
            this.toolCallId = toolCallId;
            this.output = output;
        }

        public static ToolOutputBuilder builder() {
            return new ToolOutputBuilder();
        }

        public String getToolCallId() {
            return this.toolCallId;
        }

        public String getOutput() {
            return this.output;
        }

        public String toString() {
            return "ThreadRunSubmitOutputRequest.ToolOutput(toolCallId=" + this.getToolCallId() + ", output=" + this.getOutput() + ")";
        }

        public static class ToolOutputBuilder {
            private String toolCallId;
            private String output;

            ToolOutputBuilder() {
            }

            public ToolOutputBuilder toolCallId(String toolCallId) {
                this.toolCallId = toolCallId;
                return this;
            }

            public ToolOutputBuilder output(String output) {
                this.output = output;
                return this;
            }

            public ToolOutput build() {
                return new ToolOutput(this.toolCallId, this.output);
            }

            public String toString() {
                return "ThreadRunSubmitOutputRequest.ToolOutput.ToolOutputBuilder(toolCallId=" + this.toolCallId + ", output=" + this.output + ")";
            }
        }
    }
}

