/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.sashirestela.openai.OpenAI;
import io.github.sashirestela.openai.base.ClientConfig;
import io.github.sashirestela.openai.base.OpenAIConfigurator;
import io.github.sashirestela.openai.base.OpenAIProvider;
import io.github.sashirestela.openai.service.ChatCompletionServices;
import io.github.sashirestela.openai.service.ModelServices;
import java.net.http.HttpClient;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public class SimpleOpenAIDeepseek
extends OpenAIProvider
implements ChatCompletionServices,
ModelServices {
    public SimpleOpenAIDeepseek(@NonNull String apiKey, String baseUrl, HttpClient httpClient, ObjectMapper objectMapper) {
        super(((DeepseekConfigurator.DeepseekConfiguratorBuilder)((DeepseekConfigurator.DeepseekConfiguratorBuilder)((DeepseekConfigurator.DeepseekConfiguratorBuilder)((DeepseekConfigurator.DeepseekConfiguratorBuilder)DeepseekConfigurator.builder().apiKey(apiKey)).baseUrl(baseUrl)).httpClient(httpClient)).objectMapper(objectMapper)).build());
        if (apiKey == null) {
            throw new NullPointerException("apiKey is marked non-null but is null");
        }
    }

    @Override
    public OpenAI.ChatCompletions chatCompletions() {
        return this.getOrCreateService(OpenAI.ChatCompletions.class);
    }

    @Override
    public OpenAI.Models models() {
        return this.getOrCreateService(OpenAI.Models.class);
    }

    @Generated
    public static SimpleOpenAIDeepseekBuilder builder() {
        return new SimpleOpenAIDeepseekBuilder();
    }

    @Generated
    public static class SimpleOpenAIDeepseekBuilder {
        @Generated
        private String apiKey;
        @Generated
        private String baseUrl;
        @Generated
        private HttpClient httpClient;
        @Generated
        private ObjectMapper objectMapper;

        @Generated
        SimpleOpenAIDeepseekBuilder() {
        }

        @Generated
        public SimpleOpenAIDeepseekBuilder apiKey(@NonNull String apiKey) {
            if (apiKey == null) {
                throw new NullPointerException("apiKey is marked non-null but is null");
            }
            this.apiKey = apiKey;
            return this;
        }

        @Generated
        public SimpleOpenAIDeepseekBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        @Generated
        public SimpleOpenAIDeepseekBuilder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        @Generated
        public SimpleOpenAIDeepseekBuilder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this;
        }

        @Generated
        public SimpleOpenAIDeepseek build() {
            return new SimpleOpenAIDeepseek(this.apiKey, this.baseUrl, this.httpClient, this.objectMapper);
        }

        @Generated
        public String toString() {
            return "SimpleOpenAIDeepseek.SimpleOpenAIDeepseekBuilder(apiKey=" + this.apiKey + ", baseUrl=" + this.baseUrl + ", httpClient=" + this.httpClient + ", objectMapper=" + this.objectMapper + ")";
        }
    }

    static class DeepseekConfigurator
    extends OpenAIConfigurator {
        @Override
        public ClientConfig buildConfig() {
            return ClientConfig.builder().baseUrl(Optional.ofNullable(this.baseUrl).orElse("https://api.deepseek.com")).headers(Map.of("Authorization", "Bearer " + this.apiKey)).httpClient(this.httpClient).objectMapper(this.objectMapper).build();
        }

        @Generated
        protected DeepseekConfigurator(DeepseekConfiguratorBuilder<?, ?> b) {
            super(b);
        }

        @Generated
        public static DeepseekConfiguratorBuilder<?, ?> builder() {
            return new DeepseekConfiguratorBuilderImpl();
        }

        @Generated
        private static final class DeepseekConfiguratorBuilderImpl
        extends DeepseekConfiguratorBuilder<DeepseekConfigurator, DeepseekConfiguratorBuilderImpl> {
            @Generated
            private DeepseekConfiguratorBuilderImpl() {
            }

            @Override
            @Generated
            protected DeepseekConfiguratorBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public DeepseekConfigurator build() {
                return new DeepseekConfigurator(this);
            }
        }

        @Generated
        public static abstract class DeepseekConfiguratorBuilder<C extends DeepseekConfigurator, B extends DeepseekConfiguratorBuilder<C, B>>
        extends OpenAIConfigurator.OpenAIConfiguratorBuilder<C, B> {
            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Override
            @Generated
            public String toString() {
                return "SimpleOpenAIDeepseek.DeepseekConfigurator.DeepseekConfiguratorBuilder(super=" + super.toString() + ")";
            }
        }
    }
}

