/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.realtime;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.common.function.FunctionDef;
import io.github.sashirestela.openai.common.tool.ToolChoiceOption;
import io.github.sashirestela.openai.common.tool.ToolType;
import io.github.sashirestela.openai.domain.chat.ChatRequest;
import io.github.sashirestela.slimvalidator.constraints.ObjectType;
import io.github.sashirestela.slimvalidator.constraints.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class Configuration {
    private List<ChatRequest.Modality> modalities;
    private String instructions;
    private VoiceRealtime voice;
    private AudioFormatRealtime inputAudioFormat;
    private AudioFormatRealtime outputAudioFormat;
    private InputAudioTranscription inputAudioTranscription;
    private TurnDetection turnDetection;
    private List<ToolRealtime> tools;
    @ObjectType.List(value={@ObjectType(baseClass=String.class), @ObjectType(baseClass=ToolChoiceOption.class)})
    private Object toolChoice;
    @Range(min=0.6, max=1.2)
    private Double temperature;
    @Range(min=1.0, max=4096.0)
    @ObjectType.List(value={@ObjectType(baseClass=Integer.class), @ObjectType(baseClass=String.class)})
    private Object maxResponseOutputTokens;

    @Generated
    public static ConfigurationBuilder builder() {
        return new ConfigurationBuilder();
    }

    @Generated
    public List<ChatRequest.Modality> getModalities() {
        return this.modalities;
    }

    @Generated
    public String getInstructions() {
        return this.instructions;
    }

    @Generated
    public VoiceRealtime getVoice() {
        return this.voice;
    }

    @Generated
    public AudioFormatRealtime getInputAudioFormat() {
        return this.inputAudioFormat;
    }

    @Generated
    public AudioFormatRealtime getOutputAudioFormat() {
        return this.outputAudioFormat;
    }

    @Generated
    public InputAudioTranscription getInputAudioTranscription() {
        return this.inputAudioTranscription;
    }

    @Generated
    public TurnDetection getTurnDetection() {
        return this.turnDetection;
    }

    @Generated
    public List<ToolRealtime> getTools() {
        return this.tools;
    }

    @Generated
    public Object getToolChoice() {
        return this.toolChoice;
    }

    @Generated
    public Double getTemperature() {
        return this.temperature;
    }

    @Generated
    public Object getMaxResponseOutputTokens() {
        return this.maxResponseOutputTokens;
    }

    @Generated
    public String toString() {
        return "Configuration(modalities=" + this.getModalities() + ", instructions=" + this.getInstructions() + ", voice=" + this.getVoice() + ", inputAudioFormat=" + this.getInputAudioFormat() + ", outputAudioFormat=" + this.getOutputAudioFormat() + ", inputAudioTranscription=" + this.getInputAudioTranscription() + ", turnDetection=" + this.getTurnDetection() + ", tools=" + this.getTools() + ", toolChoice=" + this.getToolChoice() + ", temperature=" + this.getTemperature() + ", maxResponseOutputTokens=" + this.getMaxResponseOutputTokens() + ")";
    }

    @Generated
    public Configuration() {
    }

    @Generated
    public Configuration(List<ChatRequest.Modality> modalities, String instructions, VoiceRealtime voice, AudioFormatRealtime inputAudioFormat, AudioFormatRealtime outputAudioFormat, InputAudioTranscription inputAudioTranscription, TurnDetection turnDetection, List<ToolRealtime> tools, Object toolChoice, Double temperature, Object maxResponseOutputTokens) {
        this.modalities = modalities;
        this.instructions = instructions;
        this.voice = voice;
        this.inputAudioFormat = inputAudioFormat;
        this.outputAudioFormat = outputAudioFormat;
        this.inputAudioTranscription = inputAudioTranscription;
        this.turnDetection = turnDetection;
        this.tools = tools;
        this.toolChoice = toolChoice;
        this.temperature = temperature;
        this.maxResponseOutputTokens = maxResponseOutputTokens;
    }

    @Generated
    public static class ConfigurationBuilder {
        @Generated
        private ArrayList<ChatRequest.Modality> modalities;
        @Generated
        private String instructions;
        @Generated
        private VoiceRealtime voice;
        @Generated
        private AudioFormatRealtime inputAudioFormat;
        @Generated
        private AudioFormatRealtime outputAudioFormat;
        @Generated
        private InputAudioTranscription inputAudioTranscription;
        @Generated
        private TurnDetection turnDetection;
        @Generated
        private ArrayList<ToolRealtime> tools;
        @Generated
        private Object toolChoice;
        @Generated
        private Double temperature;
        @Generated
        private Object maxResponseOutputTokens;

        @Generated
        ConfigurationBuilder() {
        }

        @Generated
        public ConfigurationBuilder modality(ChatRequest.Modality modality) {
            if (this.modalities == null) {
                this.modalities = new ArrayList();
            }
            this.modalities.add(modality);
            return this;
        }

        @Generated
        public ConfigurationBuilder modalities(Collection<? extends ChatRequest.Modality> modalities) {
            if (modalities == null) {
                throw new NullPointerException("modalities cannot be null");
            }
            if (this.modalities == null) {
                this.modalities = new ArrayList();
            }
            this.modalities.addAll(modalities);
            return this;
        }

        @Generated
        public ConfigurationBuilder clearModalities() {
            if (this.modalities != null) {
                this.modalities.clear();
            }
            return this;
        }

        @Generated
        public ConfigurationBuilder instructions(String instructions) {
            this.instructions = instructions;
            return this;
        }

        @Generated
        public ConfigurationBuilder voice(VoiceRealtime voice) {
            this.voice = voice;
            return this;
        }

        @Generated
        public ConfigurationBuilder inputAudioFormat(AudioFormatRealtime inputAudioFormat) {
            this.inputAudioFormat = inputAudioFormat;
            return this;
        }

        @Generated
        public ConfigurationBuilder outputAudioFormat(AudioFormatRealtime outputAudioFormat) {
            this.outputAudioFormat = outputAudioFormat;
            return this;
        }

        @Generated
        public ConfigurationBuilder inputAudioTranscription(InputAudioTranscription inputAudioTranscription) {
            this.inputAudioTranscription = inputAudioTranscription;
            return this;
        }

        @Generated
        public ConfigurationBuilder turnDetection(TurnDetection turnDetection) {
            this.turnDetection = turnDetection;
            return this;
        }

        @Generated
        public ConfigurationBuilder tool(ToolRealtime tool) {
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.add(tool);
            return this;
        }

        @Generated
        public ConfigurationBuilder tools(Collection<? extends ToolRealtime> tools) {
            if (tools == null) {
                throw new NullPointerException("tools cannot be null");
            }
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.addAll(tools);
            return this;
        }

        @Generated
        public ConfigurationBuilder clearTools() {
            if (this.tools != null) {
                this.tools.clear();
            }
            return this;
        }

        @Generated
        public ConfigurationBuilder toolChoice(Object toolChoice) {
            this.toolChoice = toolChoice;
            return this;
        }

        @Generated
        public ConfigurationBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        @Generated
        public ConfigurationBuilder maxResponseOutputTokens(Object maxResponseOutputTokens) {
            this.maxResponseOutputTokens = maxResponseOutputTokens;
            return this;
        }

        @Generated
        public Configuration build() {
            List<ToolRealtime> tools;
            List<ChatRequest.Modality> modalities;
            switch (this.modalities == null ? 0 : this.modalities.size()) {
                case 0: {
                    modalities = Collections.emptyList();
                    break;
                }
                case 1: {
                    modalities = Collections.singletonList(this.modalities.get(0));
                    break;
                }
                default: {
                    modalities = Collections.unmodifiableList(new ArrayList<ChatRequest.Modality>(this.modalities));
                }
            }
            switch (this.tools == null ? 0 : this.tools.size()) {
                case 0: {
                    tools = Collections.emptyList();
                    break;
                }
                case 1: {
                    tools = Collections.singletonList(this.tools.get(0));
                    break;
                }
                default: {
                    tools = Collections.unmodifiableList(new ArrayList<ToolRealtime>(this.tools));
                }
            }
            return new Configuration(modalities, this.instructions, this.voice, this.inputAudioFormat, this.outputAudioFormat, this.inputAudioTranscription, this.turnDetection, tools, this.toolChoice, this.temperature, this.maxResponseOutputTokens);
        }

        @Generated
        public String toString() {
            return "Configuration.ConfigurationBuilder(modalities=" + this.modalities + ", instructions=" + this.instructions + ", voice=" + this.voice + ", inputAudioFormat=" + this.inputAudioFormat + ", outputAudioFormat=" + this.outputAudioFormat + ", inputAudioTranscription=" + this.inputAudioTranscription + ", turnDetection=" + this.turnDetection + ", tools=" + this.tools + ", toolChoice=" + this.toolChoice + ", temperature=" + this.temperature + ", maxResponseOutputTokens=" + this.maxResponseOutputTokens + ")";
        }
    }

    public static class ToolRealtime {
        private ToolType type;
        private String name;
        private String description;
        private JsonNode parameters;

        public static ToolRealtime of(FunctionDef function) {
            return new ToolRealtime(ToolType.FUNCTION, function.getName(), function.getDescription(), function.getSchemaConverter().convert(function.getFunctionalClass()));
        }

        @Generated
        public ToolType getType() {
            return this.type;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public JsonNode getParameters() {
            return this.parameters;
        }

        @Generated
        public String toString() {
            return "Configuration.ToolRealtime(type=" + this.getType() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", parameters=" + this.getParameters() + ")";
        }

        @Generated
        public ToolRealtime() {
        }

        @Generated
        private ToolRealtime(ToolType type, String name, String description, JsonNode parameters) {
            this.type = type;
            this.name = name;
            this.description = description;
            this.parameters = parameters;
        }
    }

    public static class TurnDetection {
        private String type;
        @Range(min=0.0, max=1.0)
        private Double threshold;
        private Integer prefixPaddingMs;
        private Integer silenceDurationMs;

        @Generated
        private static String $default$type() {
            return "server_vad";
        }

        @Generated
        public static TurnDetectionBuilder builder() {
            return new TurnDetectionBuilder();
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public Double getThreshold() {
            return this.threshold;
        }

        @Generated
        public Integer getPrefixPaddingMs() {
            return this.prefixPaddingMs;
        }

        @Generated
        public Integer getSilenceDurationMs() {
            return this.silenceDurationMs;
        }

        @Generated
        public String toString() {
            return "Configuration.TurnDetection(type=" + this.getType() + ", threshold=" + this.getThreshold() + ", prefixPaddingMs=" + this.getPrefixPaddingMs() + ", silenceDurationMs=" + this.getSilenceDurationMs() + ")";
        }

        @Generated
        public TurnDetection() {
            this.type = TurnDetection.$default$type();
        }

        @Generated
        public TurnDetection(String type, Double threshold, Integer prefixPaddingMs, Integer silenceDurationMs) {
            this.type = type;
            this.threshold = threshold;
            this.prefixPaddingMs = prefixPaddingMs;
            this.silenceDurationMs = silenceDurationMs;
        }

        @Generated
        public static class TurnDetectionBuilder {
            @Generated
            private boolean type$set;
            @Generated
            private String type$value;
            @Generated
            private Double threshold;
            @Generated
            private Integer prefixPaddingMs;
            @Generated
            private Integer silenceDurationMs;

            @Generated
            TurnDetectionBuilder() {
            }

            @Generated
            public TurnDetectionBuilder type(String type) {
                this.type$value = type;
                this.type$set = true;
                return this;
            }

            @Generated
            public TurnDetectionBuilder threshold(Double threshold) {
                this.threshold = threshold;
                return this;
            }

            @Generated
            public TurnDetectionBuilder prefixPaddingMs(Integer prefixPaddingMs) {
                this.prefixPaddingMs = prefixPaddingMs;
                return this;
            }

            @Generated
            public TurnDetectionBuilder silenceDurationMs(Integer silenceDurationMs) {
                this.silenceDurationMs = silenceDurationMs;
                return this;
            }

            @Generated
            public TurnDetection build() {
                String type$value = this.type$value;
                if (!this.type$set) {
                    type$value = TurnDetection.$default$type();
                }
                return new TurnDetection(type$value, this.threshold, this.prefixPaddingMs, this.silenceDurationMs);
            }

            @Generated
            public String toString() {
                return "Configuration.TurnDetection.TurnDetectionBuilder(type$value=" + this.type$value + ", threshold=" + this.threshold + ", prefixPaddingMs=" + this.prefixPaddingMs + ", silenceDurationMs=" + this.silenceDurationMs + ")";
            }
        }
    }

    public static class InputAudioTranscription {
        private String model;

        public static InputAudioTranscription of(String model) {
            return new InputAudioTranscription(model);
        }

        @Generated
        public String getModel() {
            return this.model;
        }

        @Generated
        public String toString() {
            return "Configuration.InputAudioTranscription(model=" + this.getModel() + ")";
        }

        @Generated
        public InputAudioTranscription() {
        }

        @Generated
        private InputAudioTranscription(String model) {
            this.model = model;
        }
    }

    public static enum AudioFormatRealtime {
        PCM16,
        G711_ULAW,
        G711_ALAW;

    }

    public static enum VoiceRealtime {
        ASH,
        BALLAD,
        CORAL,
        SAGE,
        VERSE,
        ALLOY,
        ECHO,
        SHIMMER;

    }
}

