/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.completion;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.slimvalidator.constraints.ObjectType;
import io.github.sashirestela.slimvalidator.constraints.Range;
import io.github.sashirestela.slimvalidator.constraints.Required;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class CompletionRequest {
    @Required
    private String model;
    @Required
    @ObjectType.List(value={@ObjectType(baseClass=String.class), @ObjectType(baseClass=String.class, firstGroup=true), @ObjectType(baseClass=Integer.class, firstGroup=true), @ObjectType(baseClass=Integer.class, firstGroup=true, secondGroup=true)})
    private Object prompt;
    @Range(min=0.0, max=20.0)
    private Integer bestOf;
    private Boolean echo;
    @Range(min=-2.0, max=2.0)
    private Double frequencyPenalty;
    private Map<String, Integer> logitBias;
    @Range(min=0.0, max=5.0)
    private Integer logprobs;
    private Integer maxTokens;
    @Range(min=1.0, max=128.0)
    private Integer n;
    @Range(min=-2.0, max=2.0)
    private Double presencePenalty;
    private Integer seed;
    @ObjectType.List(value={@ObjectType(baseClass=String.class), @ObjectType(baseClass=String.class, firstGroup=true, maxSize=4)})
    private Object stop;
    private Boolean stream;
    private String suffix;
    @Range(min=0.0, max=2.0)
    private Double temperature;
    @Range(min=0.0, max=1.0)
    private Double topP;
    private String user;

    CompletionRequest(String model, Object prompt, Integer bestOf, Boolean echo, Double frequencyPenalty, Map<String, Integer> logitBias, Integer logprobs, Integer maxTokens, Integer n, Double presencePenalty, Integer seed, Object stop, Boolean stream, String suffix, Double temperature, Double topP, String user) {
        this.model = model;
        this.prompt = prompt;
        this.bestOf = bestOf;
        this.echo = echo;
        this.frequencyPenalty = frequencyPenalty;
        this.logitBias = logitBias;
        this.logprobs = logprobs;
        this.maxTokens = maxTokens;
        this.n = n;
        this.presencePenalty = presencePenalty;
        this.seed = seed;
        this.stop = stop;
        this.stream = stream;
        this.suffix = suffix;
        this.temperature = temperature;
        this.topP = topP;
        this.user = user;
    }

    public static CompletionRequestBuilder builder() {
        return new CompletionRequestBuilder();
    }

    public String getModel() {
        return this.model;
    }

    public Object getPrompt() {
        return this.prompt;
    }

    public Integer getBestOf() {
        return this.bestOf;
    }

    public Boolean getEcho() {
        return this.echo;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public Map<String, Integer> getLogitBias() {
        return this.logitBias;
    }

    public Integer getLogprobs() {
        return this.logprobs;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public Integer getN() {
        return this.n;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public Object getStop() {
        return this.stop;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public String getUser() {
        return this.user;
    }

    public CompletionRequest withStream(Boolean stream) {
        return this.stream == stream ? this : new CompletionRequest(this.model, this.prompt, this.bestOf, this.echo, this.frequencyPenalty, this.logitBias, this.logprobs, this.maxTokens, this.n, this.presencePenalty, this.seed, this.stop, stream, this.suffix, this.temperature, this.topP, this.user);
    }

    public static class CompletionRequestBuilder {
        private String model;
        private Object prompt;
        private Integer bestOf;
        private Boolean echo;
        private Double frequencyPenalty;
        private Map<String, Integer> logitBias;
        private Integer logprobs;
        private Integer maxTokens;
        private Integer n;
        private Double presencePenalty;
        private Integer seed;
        private Object stop;
        private Boolean stream;
        private String suffix;
        private Double temperature;
        private Double topP;
        private String user;

        CompletionRequestBuilder() {
        }

        public CompletionRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        public CompletionRequestBuilder prompt(Object prompt) {
            this.prompt = prompt;
            return this;
        }

        public CompletionRequestBuilder bestOf(Integer bestOf) {
            this.bestOf = bestOf;
            return this;
        }

        public CompletionRequestBuilder echo(Boolean echo) {
            this.echo = echo;
            return this;
        }

        public CompletionRequestBuilder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public CompletionRequestBuilder logitBias(Map<String, Integer> logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        public CompletionRequestBuilder logprobs(Integer logprobs) {
            this.logprobs = logprobs;
            return this;
        }

        public CompletionRequestBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        public CompletionRequestBuilder n(Integer n) {
            this.n = n;
            return this;
        }

        public CompletionRequestBuilder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        public CompletionRequestBuilder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public CompletionRequestBuilder stop(Object stop) {
            this.stop = stop;
            return this;
        }

        public CompletionRequestBuilder stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        public CompletionRequestBuilder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public CompletionRequestBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public CompletionRequestBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public CompletionRequestBuilder user(String user) {
            this.user = user;
            return this;
        }

        public CompletionRequest build() {
            return new CompletionRequest(this.model, this.prompt, this.bestOf, this.echo, this.frequencyPenalty, this.logitBias, this.logprobs, this.maxTokens, this.n, this.presencePenalty, this.seed, this.stop, this.stream, this.suffix, this.temperature, this.topP, this.user);
        }

        public String toString() {
            return "CompletionRequest.CompletionRequestBuilder(model=" + this.model + ", prompt=" + this.prompt + ", bestOf=" + this.bestOf + ", echo=" + this.echo + ", frequencyPenalty=" + this.frequencyPenalty + ", logitBias=" + this.logitBias + ", logprobs=" + this.logprobs + ", maxTokens=" + this.maxTokens + ", n=" + this.n + ", presencePenalty=" + this.presencePenalty + ", seed=" + this.seed + ", stop=" + this.stop + ", stream=" + this.stream + ", suffix=" + this.suffix + ", temperature=" + this.temperature + ", topP=" + this.topP + ", user=" + this.user + ")";
        }
    }
}

