/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.assistant;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.domain.assistant.Attachment;
import io.github.sashirestela.openai.domain.assistant.ThreadMessageRole;
import io.github.sashirestela.slimvalidator.constraints.Required;
import io.github.sashirestela.slimvalidator.constraints.Size;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class ThreadMessageRequest {
    @Required
    private ThreadMessageRole role;
    @Required
    @Size(max=256000)
    private String content;
    private List<Attachment> attachments;
    @Size(max=16)
    private Map<String, String> metadata;

    ThreadMessageRequest(ThreadMessageRole role, String content, List<Attachment> attachments, Map<String, String> metadata) {
        this.role = role;
        this.content = content;
        this.attachments = attachments;
        this.metadata = metadata;
    }

    public static ThreadMessageRequestBuilder builder() {
        return new ThreadMessageRequestBuilder();
    }

    public ThreadMessageRole getRole() {
        return this.role;
    }

    public String getContent() {
        return this.content;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class ThreadMessageRequestBuilder {
        private ThreadMessageRole role;
        private String content;
        private ArrayList<Attachment> attachments;
        private Map<String, String> metadata;

        ThreadMessageRequestBuilder() {
        }

        public ThreadMessageRequestBuilder role(ThreadMessageRole role) {
            this.role = role;
            return this;
        }

        public ThreadMessageRequestBuilder content(String content) {
            this.content = content;
            return this;
        }

        public ThreadMessageRequestBuilder attachment(Attachment attachment) {
            if (this.attachments == null) {
                this.attachments = new ArrayList();
            }
            this.attachments.add(attachment);
            return this;
        }

        public ThreadMessageRequestBuilder attachments(Collection<? extends Attachment> attachments) {
            if (attachments == null) {
                throw new NullPointerException("attachments cannot be null");
            }
            if (this.attachments == null) {
                this.attachments = new ArrayList();
            }
            this.attachments.addAll(attachments);
            return this;
        }

        public ThreadMessageRequestBuilder clearAttachments() {
            if (this.attachments != null) {
                this.attachments.clear();
            }
            return this;
        }

        public ThreadMessageRequestBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public ThreadMessageRequest build() {
            List<Attachment> attachments;
            switch (this.attachments == null ? 0 : this.attachments.size()) {
                case 0: {
                    attachments = Collections.emptyList();
                    break;
                }
                case 1: {
                    attachments = Collections.singletonList(this.attachments.get(0));
                    break;
                }
                default: {
                    attachments = Collections.unmodifiableList(new ArrayList<Attachment>(this.attachments));
                }
            }
            return new ThreadMessageRequest(this.role, this.content, attachments, this.metadata);
        }

        public String toString() {
            return "ThreadMessageRequest.ThreadMessageRequestBuilder(role=" + this.role + ", content=" + this.content + ", attachments=" + this.attachments + ", metadata=" + this.metadata + ")";
        }
    }
}

