/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.file;

import io.github.sashirestela.openai.domain.file.PurposeType;
import io.github.sashirestela.slimvalidator.constraints.Required;
import java.nio.file.Path;

public class FileRequest {
    @Required
    private Path file;
    @Required
    private PurposeType purpose;

    FileRequest(Path file, PurposeType purpose) {
        this.file = file;
        this.purpose = purpose;
    }

    public static FileRequestBuilder builder() {
        return new FileRequestBuilder();
    }

    public Path getFile() {
        return this.file;
    }

    public PurposeType getPurpose() {
        return this.purpose;
    }

    public static class FileRequestBuilder {
        private Path file;
        private PurposeType purpose;

        FileRequestBuilder() {
        }

        public FileRequestBuilder file(Path file) {
            this.file = file;
            return this;
        }

        public FileRequestBuilder purpose(PurposeType purpose) {
            this.purpose = purpose;
            return this;
        }

        public FileRequest build() {
            return new FileRequest(this.file, this.purpose);
        }

        public String toString() {
            return "FileRequest.FileRequestBuilder(file=" + this.file + ", purpose=" + this.purpose + ")";
        }
    }
}

