/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai;

import io.github.sashirestela.cleverclient.Event;
import io.github.sashirestela.cleverclient.annotation.Body;
import io.github.sashirestela.cleverclient.annotation.DELETE;
import io.github.sashirestela.cleverclient.annotation.GET;
import io.github.sashirestela.cleverclient.annotation.Header;
import io.github.sashirestela.cleverclient.annotation.POST;
import io.github.sashirestela.cleverclient.annotation.Path;
import io.github.sashirestela.cleverclient.annotation.Query;
import io.github.sashirestela.cleverclient.annotation.Resource;
import io.github.sashirestela.openai.domain.OpenAIDeletedResponse;
import io.github.sashirestela.openai.domain.Page;
import io.github.sashirestela.openai.domain.PageRequest;
import io.github.sashirestela.openai.domain.assistant.Assistant;
import io.github.sashirestela.openai.domain.assistant.AssistantFile;
import io.github.sashirestela.openai.domain.assistant.AssistantRequest;
import io.github.sashirestela.openai.domain.assistant.AssistantStreamEvents;
import io.github.sashirestela.openai.domain.assistant.FilePath;
import io.github.sashirestela.openai.domain.assistant.Thread;
import io.github.sashirestela.openai.domain.assistant.ThreadCreateAndRunRequest;
import io.github.sashirestela.openai.domain.assistant.ThreadMessage;
import io.github.sashirestela.openai.domain.assistant.ThreadMessageFile;
import io.github.sashirestela.openai.domain.assistant.ThreadMessageModifyRequest;
import io.github.sashirestela.openai.domain.assistant.ThreadMessageRequest;
import io.github.sashirestela.openai.domain.assistant.ThreadModifyRequest;
import io.github.sashirestela.openai.domain.assistant.ThreadRequest;
import io.github.sashirestela.openai.domain.assistant.ThreadRun;
import io.github.sashirestela.openai.domain.assistant.ThreadRunModifyRequest;
import io.github.sashirestela.openai.domain.assistant.ThreadRunRequest;
import io.github.sashirestela.openai.domain.assistant.ThreadRunStep;
import io.github.sashirestela.openai.domain.assistant.ToolOutput;
import io.github.sashirestela.openai.domain.assistant.ToolOutputSubmission;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;

public interface OpenAIBeta {

    @Resource(value="/v1/threads")
    @Header(name="OpenAI-Beta", value="assistants=v1")
    public static interface Threads {
        default public CompletableFuture<Thread> create() {
            return this.create(ThreadRequest.builder().build());
        }

        @POST
        public CompletableFuture<Thread> create(@Body ThreadRequest var1);

        @GET(value="/{threadId}")
        public CompletableFuture<Thread> getOne(@Path(value="threadId") String var1);

        @POST(value="/{threadId}")
        public CompletableFuture<Thread> modify(@Path(value="threadId") String var1, @Body ThreadModifyRequest var2);

        @DELETE(value="/{threadId}")
        public CompletableFuture<OpenAIDeletedResponse> delete(@Path(value="threadId") String var1);

        @POST(value="/{threadId}/messages")
        public CompletableFuture<ThreadMessage> createMessage(@Path(value="threadId") String var1, @Body ThreadMessageRequest var2);

        @GET(value="/{threadId}/messages/{messageId}")
        public CompletableFuture<ThreadMessage> getMessage(@Path(value="threadId") String var1, @Path(value="messageId") String var2);

        @POST(value="/{threadId}/messages/{messageId}")
        public CompletableFuture<ThreadMessage> modifyMessage(@Path(value="threadId") String var1, @Path(value="messageId") String var2, @Body ThreadMessageModifyRequest var3);

        default public CompletableFuture<Page<ThreadMessage>> getMessageList(String threadId) {
            return this.getMessageList(threadId, PageRequest.builder().build(), null);
        }

        @GET(value="/{threadId}/messages")
        public CompletableFuture<Page<ThreadMessage>> getMessageList(@Path(value="threadId") String var1, @Query PageRequest var2, @Query(value="run_id") String var3);

        @POST(value="/{threadId}/messages/{messageId}")
        public CompletableFuture<OpenAIDeletedResponse> deleteMessage(@Path(value="threadId") String var1, @Path(value="messageId") String var2);

        @GET(value="/{threadId}/messages/{messageId}/files/{fileId}")
        public CompletableFuture<ThreadMessageFile> getMessageFile(@Path(value="threadId") String var1, @Path(value="messageId") String var2, @Path(value="fileId") String var3);

        default public CompletableFuture<Page<ThreadMessageFile>> getMessageFileList(String threadId, String messageId) {
            return this.getMessageFileList(threadId, messageId, PageRequest.builder().build());
        }

        @GET(value="/{threadId}/messages/{messageId}/files")
        public CompletableFuture<Page<ThreadMessageFile>> getMessageFileList(@Path(value="threadId") String var1, @Path(value="messageId") String var2, @Query PageRequest var3);

        default public CompletableFuture<ThreadRun> createRun(String threadId, String assistantId) {
            return this.createRunRoot(threadId, ThreadRunRequest.builder().assistantId(assistantId).stream(Boolean.FALSE).build());
        }

        default public CompletableFuture<ThreadRun> createRun(@Path(value="threadId") String threadId, @Body ThreadRunRequest request) {
            ThreadRunRequest newRequest = request.withStream(Boolean.FALSE);
            return this.createRunRoot(threadId, newRequest);
        }

        @POST(value="/{threadId}/runs")
        public CompletableFuture<ThreadRun> createRunRoot(@Path(value="threadId") String var1, @Body ThreadRunRequest var2);

        default public CompletableFuture<Stream<Event>> createRunStream(@Path(value="threadId") String threadId, @Body ThreadRunRequest request) {
            ThreadRunRequest newRequest = request.withStream(Boolean.TRUE);
            return this.createRunStreamRoot(threadId, newRequest);
        }

        @POST(value="/{threadId}/runs")
        @AssistantStreamEvents
        public CompletableFuture<Stream<Event>> createRunStreamRoot(@Path(value="threadId") String var1, @Body ThreadRunRequest var2);

        @GET(value="/{threadId}/runs/{runId}")
        public CompletableFuture<ThreadRun> getRun(@Path(value="threadId") String var1, @Path(value="runId") String var2);

        @POST(value="/{threadId}/runs/{runId}")
        public CompletableFuture<ThreadRun> modifyRun(@Path(value="threadId") String var1, @Path(value="runId") String var2, @Body ThreadRunModifyRequest var3);

        default public CompletableFuture<Page<ThreadRun>> getRunList(String threadId) {
            return this.getRunList(threadId, PageRequest.builder().build());
        }

        @GET(value="/{threadId}/runs")
        public CompletableFuture<Page<ThreadRun>> getRunList(@Path(value="threadId") String var1, @Query PageRequest var2);

        default public CompletableFuture<ThreadRun> submitToolOutputs(String threadId, String runId, List<ToolOutput> toolOutputs) {
            return this.submitToolOutputs(threadId, runId, ToolOutputSubmission.builder().toolOutputs(toolOutputs).build());
        }

        default public CompletableFuture<ThreadRun> submitToolOutputs(@Path(value="threadId") String threadId, @Path(value="runId") String runId, @Body ToolOutputSubmission toolOutputs) {
            ToolOutputSubmission newToolOutputs = toolOutputs.withStream(Boolean.FALSE);
            return this.submitToolOutputsRoot(threadId, runId, newToolOutputs);
        }

        @POST(value="/{threadId}/runs/{runId}/submit_tool_outputs")
        public CompletableFuture<ThreadRun> submitToolOutputsRoot(@Path(value="threadId") String var1, @Path(value="runId") String var2, @Body ToolOutputSubmission var3);

        default public CompletableFuture<Stream<Event>> submitToolOutputsStream(@Path(value="threadId") String threadId, @Path(value="runId") String runId, @Body ToolOutputSubmission toolOutputs) {
            ToolOutputSubmission newToolOutputs = toolOutputs.withStream(Boolean.TRUE);
            return this.submitToolOutputsStreamRoot(threadId, runId, newToolOutputs);
        }

        @POST(value="/{threadId}/runs/{runId}/submit_tool_outputs")
        @AssistantStreamEvents
        public CompletableFuture<Stream<Event>> submitToolOutputsStreamRoot(@Path(value="threadId") String var1, @Path(value="runId") String var2, @Body ToolOutputSubmission var3);

        @POST(value="/{threadId}/runs/{runId}/cancel")
        public CompletableFuture<ThreadRun> cancelRun(@Path(value="threadId") String var1, @Path(value="runId") String var2);

        default public CompletableFuture<ThreadRun> createThreadAndRun(@Body ThreadCreateAndRunRequest request) {
            ThreadCreateAndRunRequest newRequest = request.withStream(Boolean.FALSE);
            return this.createThreadAndRunRoot(newRequest);
        }

        @POST(value="/runs")
        public CompletableFuture<ThreadRun> createThreadAndRunRoot(@Body ThreadCreateAndRunRequest var1);

        default public CompletableFuture<Stream<Event>> createThreadAndRunStream(@Body ThreadCreateAndRunRequest request) {
            ThreadCreateAndRunRequest newRequest = request.withStream(Boolean.TRUE);
            return this.createThreadAndRunStreamRoot(newRequest);
        }

        @POST(value="/runs")
        @AssistantStreamEvents
        public CompletableFuture<Stream<Event>> createThreadAndRunStreamRoot(@Body ThreadCreateAndRunRequest var1);

        @GET(value="/{threadId}/runs/{runId}/steps/{stepId}")
        public CompletableFuture<ThreadRunStep> getRunStep(@Path(value="threadId") String var1, @Path(value="runId") String var2, @Path(value="stepId") String var3);

        default public CompletableFuture<Page<ThreadRunStep>> getRunStepList(String threadId, String runId) {
            return this.getRunStepList(threadId, runId, PageRequest.builder().build());
        }

        @GET(value="/{threadId}/runs/{runId}/steps")
        public CompletableFuture<Page<ThreadRunStep>> getRunStepList(@Path(value="threadId") String var1, @Path(value="runId") String var2, @Query PageRequest var3);
    }

    @Resource(value="/v1/assistants")
    @Header(name="OpenAI-Beta", value="assistants=v1")
    public static interface Assistants {
        @POST
        public CompletableFuture<Assistant> create(@Body AssistantRequest var1);

        @GET(value="/{assistantId}")
        public CompletableFuture<Assistant> getOne(@Path(value="assistantId") String var1);

        @POST(value="/{assistantId}")
        public CompletableFuture<Assistant> modify(@Path(value="assistantId") String var1, @Body AssistantRequest var2);

        @DELETE(value="/{assistantId}")
        public CompletableFuture<OpenAIDeletedResponse> delete(@Path(value="assistantId") String var1);

        default public CompletableFuture<Page<Assistant>> getList() {
            return this.getList(PageRequest.builder().build());
        }

        @GET
        public CompletableFuture<Page<Assistant>> getList(@Query PageRequest var1);

        default public CompletableFuture<AssistantFile> createFile(String assistantId, String fileId) {
            return this.createFile(assistantId, FilePath.of(fileId));
        }

        @POST(value="/{assistantId}/files")
        public CompletableFuture<AssistantFile> createFile(@Path(value="assistantId") String var1, @Body FilePath var2);

        @GET(value="/{assistantId}/files/{fileId}")
        public CompletableFuture<AssistantFile> getFile(@Path(value="assistantId") String var1, @Path(value="fileId") String var2);

        @DELETE(value="/{assistantId}/files/{fileId}")
        public CompletableFuture<OpenAIDeletedResponse> deleteFile(@Path(value="assistantId") String var1, @Path(value="fileId") String var2);

        default public CompletableFuture<Page<AssistantFile>> getFileList(String assistantId) {
            return this.getFileList(assistantId, PageRequest.builder().build());
        }

        @GET(value="/{assistantId}/files")
        public CompletableFuture<Page<AssistantFile>> getFileList(@Path(value="assistantId") String var1, @Query PageRequest var2);
    }
}

