/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.audio;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.domain.audio.AudioRespFmt;
import io.github.sashirestela.slimvalidator.constraints.Extension;
import io.github.sashirestela.slimvalidator.constraints.Range;
import io.github.sashirestela.slimvalidator.constraints.Required;
import java.nio.file.Path;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class AudioTranslateRequest {
    @Required
    @Extension(value={"flac", "mp3", "mp4", "mpeg", "mpga", "m4a", "ogg", "wav", "webm"})
    private Path file;
    @Required
    private String model;
    private String prompt;
    @Range(min=0.0, max=1.0)
    private Double temperature;
    private AudioRespFmt responseFormat;

    AudioTranslateRequest(Path file, String model, String prompt, Double temperature, AudioRespFmt responseFormat) {
        this.file = file;
        this.model = model;
        this.prompt = prompt;
        this.temperature = temperature;
        this.responseFormat = responseFormat;
    }

    public static AudioTranslateRequestBuilder builder() {
        return new AudioTranslateRequestBuilder();
    }

    public Path getFile() {
        return this.file;
    }

    public String getModel() {
        return this.model;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public AudioRespFmt getResponseFormat() {
        return this.responseFormat;
    }

    public AudioTranslateRequest withResponseFormat(AudioRespFmt responseFormat) {
        return this.responseFormat == responseFormat ? this : new AudioTranslateRequest(this.file, this.model, this.prompt, this.temperature, responseFormat);
    }

    public static class AudioTranslateRequestBuilder {
        private Path file;
        private String model;
        private String prompt;
        private Double temperature;
        private AudioRespFmt responseFormat;

        AudioTranslateRequestBuilder() {
        }

        public AudioTranslateRequestBuilder file(Path file) {
            this.file = file;
            return this;
        }

        public AudioTranslateRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        public AudioTranslateRequestBuilder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public AudioTranslateRequestBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public AudioTranslateRequestBuilder responseFormat(AudioRespFmt responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public AudioTranslateRequest build() {
            return new AudioTranslateRequest(this.file, this.model, this.prompt, this.temperature, this.responseFormat);
        }

        public String toString() {
            return "AudioTranslateRequest.AudioTranslateRequestBuilder(file=" + this.file + ", model=" + this.model + ", prompt=" + this.prompt + ", temperature=" + this.temperature + ", responseFormat=" + this.responseFormat + ")";
        }
    }
}

