/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.finetuning;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.domain.finetuning.HyperParams;
import io.github.sashirestela.openai.domain.finetuning.Integration;
import io.github.sashirestela.slimvalidator.constraints.Required;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class FineTuningRequest {
    @Required
    private String model;
    @Required
    private String trainingFile;
    private String validationFile;
    private HyperParams hyperparameters;
    private String suffix;
    private List<Integration> integrations;
    private Integer seed;

    FineTuningRequest(String model, String trainingFile, String validationFile, HyperParams hyperparameters, String suffix, List<Integration> integrations, Integer seed) {
        this.model = model;
        this.trainingFile = trainingFile;
        this.validationFile = validationFile;
        this.hyperparameters = hyperparameters;
        this.suffix = suffix;
        this.integrations = integrations;
        this.seed = seed;
    }

    public static FineTuningRequestBuilder builder() {
        return new FineTuningRequestBuilder();
    }

    public String getModel() {
        return this.model;
    }

    public String getTrainingFile() {
        return this.trainingFile;
    }

    public String getValidationFile() {
        return this.validationFile;
    }

    public HyperParams getHyperparameters() {
        return this.hyperparameters;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public List<Integration> getIntegrations() {
        return this.integrations;
    }

    public Integer getSeed() {
        return this.seed;
    }

    public static class FineTuningRequestBuilder {
        private String model;
        private String trainingFile;
        private String validationFile;
        private HyperParams hyperparameters;
        private String suffix;
        private ArrayList<Integration> integrations;
        private Integer seed;

        FineTuningRequestBuilder() {
        }

        public FineTuningRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        public FineTuningRequestBuilder trainingFile(String trainingFile) {
            this.trainingFile = trainingFile;
            return this;
        }

        public FineTuningRequestBuilder validationFile(String validationFile) {
            this.validationFile = validationFile;
            return this;
        }

        public FineTuningRequestBuilder hyperparameters(HyperParams hyperparameters) {
            this.hyperparameters = hyperparameters;
            return this;
        }

        public FineTuningRequestBuilder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public FineTuningRequestBuilder integration(Integration integration) {
            if (this.integrations == null) {
                this.integrations = new ArrayList();
            }
            this.integrations.add(integration);
            return this;
        }

        public FineTuningRequestBuilder integrations(Collection<? extends Integration> integrations) {
            if (integrations == null) {
                throw new NullPointerException("integrations cannot be null");
            }
            if (this.integrations == null) {
                this.integrations = new ArrayList();
            }
            this.integrations.addAll(integrations);
            return this;
        }

        public FineTuningRequestBuilder clearIntegrations() {
            if (this.integrations != null) {
                this.integrations.clear();
            }
            return this;
        }

        public FineTuningRequestBuilder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public FineTuningRequest build() {
            List<Integration> integrations;
            switch (this.integrations == null ? 0 : this.integrations.size()) {
                case 0: {
                    integrations = Collections.emptyList();
                    break;
                }
                case 1: {
                    integrations = Collections.singletonList(this.integrations.get(0));
                    break;
                }
                default: {
                    integrations = Collections.unmodifiableList(new ArrayList<Integration>(this.integrations));
                }
            }
            return new FineTuningRequest(this.model, this.trainingFile, this.validationFile, this.hyperparameters, this.suffix, integrations, this.seed);
        }

        public String toString() {
            return "FineTuningRequest.FineTuningRequestBuilder(model=" + this.model + ", trainingFile=" + this.trainingFile + ", validationFile=" + this.validationFile + ", hyperparameters=" + this.hyperparameters + ", suffix=" + this.suffix + ", integrations=" + this.integrations + ", seed=" + this.seed + ")";
        }
    }
}

