/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.audio;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.domain.audio.SpeechRespFmt;
import io.github.sashirestela.openai.domain.audio.Voice;
import io.github.sashirestela.slimvalidator.constraints.Range;
import io.github.sashirestela.slimvalidator.constraints.Required;
import io.github.sashirestela.slimvalidator.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class AudioSpeechRequest {
    @Required
    private String model;
    @Required
    @Size(max=4096)
    private String input;
    @Required
    private Voice voice;
    private SpeechRespFmt responseFormat;
    @Range(min=0.25, max=4.0)
    private Double speed;

    AudioSpeechRequest(String model, String input, Voice voice, SpeechRespFmt responseFormat, Double speed) {
        this.model = model;
        this.input = input;
        this.voice = voice;
        this.responseFormat = responseFormat;
        this.speed = speed;
    }

    public static AudioSpeechRequestBuilder builder() {
        return new AudioSpeechRequestBuilder();
    }

    public String getModel() {
        return this.model;
    }

    public String getInput() {
        return this.input;
    }

    public Voice getVoice() {
        return this.voice;
    }

    public SpeechRespFmt getResponseFormat() {
        return this.responseFormat;
    }

    public Double getSpeed() {
        return this.speed;
    }

    public static class AudioSpeechRequestBuilder {
        private String model;
        private String input;
        private Voice voice;
        private SpeechRespFmt responseFormat;
        private Double speed;

        AudioSpeechRequestBuilder() {
        }

        public AudioSpeechRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        public AudioSpeechRequestBuilder input(String input) {
            this.input = input;
            return this;
        }

        public AudioSpeechRequestBuilder voice(Voice voice) {
            this.voice = voice;
            return this;
        }

        public AudioSpeechRequestBuilder responseFormat(SpeechRespFmt responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public AudioSpeechRequestBuilder speed(Double speed) {
            this.speed = speed;
            return this;
        }

        public AudioSpeechRequest build() {
            return new AudioSpeechRequest(this.model, this.input, this.voice, this.responseFormat, this.speed);
        }

        public String toString() {
            return "AudioSpeechRequest.AudioSpeechRequestBuilder(model=" + this.model + ", input=" + this.input + ", voice=" + this.voice + ", responseFormat=" + this.responseFormat + ", speed=" + this.speed + ")";
        }
    }
}

