/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.assistant;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.slimvalidator.constraints.Required;
import io.github.sashirestela.slimvalidator.constraints.Size;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class ThreadMessageRequest {
    @Required
    private Role role;
    @Required
    private String content;
    @Size(max=10)
    private List<String> fileIds;
    @Size(max=16)
    private Map<String, String> metadata;

    ThreadMessageRequest(Role role, String content, List<String> fileIds, Map<String, String> metadata) {
        this.role = role;
        this.content = content;
        this.fileIds = fileIds;
        this.metadata = metadata;
    }

    public static ThreadMessageRequestBuilder builder() {
        return new ThreadMessageRequestBuilder();
    }

    public Role getRole() {
        return this.role;
    }

    public String getContent() {
        return this.content;
    }

    public List<String> getFileIds() {
        return this.fileIds;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class ThreadMessageRequestBuilder {
        private Role role;
        private String content;
        private ArrayList<String> fileIds;
        private Map<String, String> metadata;

        ThreadMessageRequestBuilder() {
        }

        public ThreadMessageRequestBuilder role(Role role) {
            this.role = role;
            return this;
        }

        public ThreadMessageRequestBuilder content(String content) {
            this.content = content;
            return this;
        }

        public ThreadMessageRequestBuilder fileId(String fileId) {
            if (this.fileIds == null) {
                this.fileIds = new ArrayList();
            }
            this.fileIds.add(fileId);
            return this;
        }

        public ThreadMessageRequestBuilder fileIds(Collection<? extends String> fileIds) {
            if (fileIds == null) {
                throw new NullPointerException("fileIds cannot be null");
            }
            if (this.fileIds == null) {
                this.fileIds = new ArrayList();
            }
            this.fileIds.addAll(fileIds);
            return this;
        }

        public ThreadMessageRequestBuilder clearFileIds() {
            if (this.fileIds != null) {
                this.fileIds.clear();
            }
            return this;
        }

        public ThreadMessageRequestBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public ThreadMessageRequest build() {
            List<String> fileIds;
            switch (this.fileIds == null ? 0 : this.fileIds.size()) {
                case 0: {
                    fileIds = Collections.emptyList();
                    break;
                }
                case 1: {
                    fileIds = Collections.singletonList(this.fileIds.get(0));
                    break;
                }
                default: {
                    fileIds = Collections.unmodifiableList(new ArrayList<String>(this.fileIds));
                }
            }
            return new ThreadMessageRequest(this.role, this.content, fileIds, this.metadata);
        }

        public String toString() {
            return "ThreadMessageRequest.ThreadMessageRequestBuilder(role=" + this.role + ", content=" + this.content + ", fileIds=" + this.fileIds + ", metadata=" + this.metadata + ")";
        }
    }

    public static enum Role {
        USER,
        ASSISTANT;

    }
}

