/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.audio;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.domain.audio.AudioRespFmt;
import java.nio.file.Path;
import lombok.NonNull;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class AudioTranslateRequest {
    @NonNull
    private Path file;
    @NonNull
    private String model;
    private String prompt;
    private Double temperature;
    private AudioRespFmt responseFormat;

    AudioTranslateRequest(@NonNull Path file, @NonNull String model, String prompt, Double temperature, AudioRespFmt responseFormat) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        this.file = file;
        this.model = model;
        this.prompt = prompt;
        this.temperature = temperature;
        this.responseFormat = responseFormat;
    }

    public static AudioTranslateRequestBuilder builder() {
        return new AudioTranslateRequestBuilder();
    }

    @NonNull
    public Path getFile() {
        return this.file;
    }

    @NonNull
    public String getModel() {
        return this.model;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public AudioRespFmt getResponseFormat() {
        return this.responseFormat;
    }

    public AudioTranslateRequest withResponseFormat(AudioRespFmt responseFormat) {
        return this.responseFormat == responseFormat ? this : new AudioTranslateRequest(this.file, this.model, this.prompt, this.temperature, responseFormat);
    }

    public static class AudioTranslateRequestBuilder {
        private Path file;
        private String model;
        private String prompt;
        private Double temperature;
        private AudioRespFmt responseFormat;

        AudioTranslateRequestBuilder() {
        }

        public AudioTranslateRequestBuilder file(@NonNull Path file) {
            if (file == null) {
                throw new NullPointerException("file is marked non-null but is null");
            }
            this.file = file;
            return this;
        }

        public AudioTranslateRequestBuilder model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model = model;
            return this;
        }

        public AudioTranslateRequestBuilder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public AudioTranslateRequestBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        public AudioTranslateRequestBuilder responseFormat(AudioRespFmt responseFormat) {
            this.responseFormat = responseFormat;
            return this;
        }

        public AudioTranslateRequest build() {
            return new AudioTranslateRequest(this.file, this.model, this.prompt, this.temperature, this.responseFormat);
        }

        public String toString() {
            return "AudioTranslateRequest.AudioTranslateRequestBuilder(file=" + this.file + ", model=" + this.model + ", prompt=" + this.prompt + ", temperature=" + this.temperature + ", responseFormat=" + this.responseFormat + ")";
        }
    }
}

