/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.assistant;

import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.domain.assistant.ToolOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class ToolOutputSubmission {
    @NonNull
    private List<ToolOutput> toolOutputs;
    private boolean stream;

    ToolOutputSubmission(@NonNull List<ToolOutput> toolOutputs, boolean stream) {
        if (toolOutputs == null) {
            throw new NullPointerException("toolOutputs is marked non-null but is null");
        }
        this.toolOutputs = toolOutputs;
        this.stream = stream;
    }

    public static ToolOutputSubmissionBuilder builder() {
        return new ToolOutputSubmissionBuilder();
    }

    @NonNull
    public List<ToolOutput> getToolOutputs() {
        return this.toolOutputs;
    }

    public boolean isStream() {
        return this.stream;
    }

    public ToolOutputSubmission withStream(boolean stream) {
        return this.stream == stream ? this : new ToolOutputSubmission(this.toolOutputs, stream);
    }

    public static class ToolOutputSubmissionBuilder {
        private ArrayList<ToolOutput> toolOutputs;
        private boolean stream;

        ToolOutputSubmissionBuilder() {
        }

        public ToolOutputSubmissionBuilder toolOutput(ToolOutput toolOutput) {
            if (this.toolOutputs == null) {
                this.toolOutputs = new ArrayList();
            }
            this.toolOutputs.add(toolOutput);
            return this;
        }

        public ToolOutputSubmissionBuilder toolOutputs(Collection<? extends ToolOutput> toolOutputs) {
            if (toolOutputs == null) {
                throw new NullPointerException("toolOutputs cannot be null");
            }
            if (this.toolOutputs == null) {
                this.toolOutputs = new ArrayList();
            }
            this.toolOutputs.addAll(toolOutputs);
            return this;
        }

        public ToolOutputSubmissionBuilder clearToolOutputs() {
            if (this.toolOutputs != null) {
                this.toolOutputs.clear();
            }
            return this;
        }

        public ToolOutputSubmissionBuilder stream(boolean stream) {
            this.stream = stream;
            return this;
        }

        public ToolOutputSubmission build() {
            List<ToolOutput> toolOutputs;
            switch (this.toolOutputs == null ? 0 : this.toolOutputs.size()) {
                case 0: {
                    toolOutputs = Collections.emptyList();
                    break;
                }
                case 1: {
                    toolOutputs = Collections.singletonList(this.toolOutputs.get(0));
                    break;
                }
                default: {
                    toolOutputs = Collections.unmodifiableList(new ArrayList<ToolOutput>(this.toolOutputs));
                }
            }
            return new ToolOutputSubmission(toolOutputs, this.stream);
        }

        public String toString() {
            return "ToolOutputSubmission.ToolOutputSubmissionBuilder(toolOutputs=" + this.toolOutputs + ", stream=" + this.stream + ")";
        }
    }
}

