/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.assistant;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.github.sashirestela.openai.domain.assistant.AssistantTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class ThreadRunRequest {
    private String assistantId;
    private String model;
    private String instructions;
    private String additionalInstructions;
    private List<AssistantTool> tools;
    private Map<String, String> metadata;
    private boolean stream;

    ThreadRunRequest(String assistantId, String model, String instructions, String additionalInstructions, List<AssistantTool> tools, Map<String, String> metadata, boolean stream) {
        this.assistantId = assistantId;
        this.model = model;
        this.instructions = instructions;
        this.additionalInstructions = additionalInstructions;
        this.tools = tools;
        this.metadata = metadata;
        this.stream = stream;
    }

    public static ThreadRunRequestBuilder builder() {
        return new ThreadRunRequestBuilder();
    }

    public String getAssistantId() {
        return this.assistantId;
    }

    public String getModel() {
        return this.model;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public String getAdditionalInstructions() {
        return this.additionalInstructions;
    }

    public List<AssistantTool> getTools() {
        return this.tools;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public boolean isStream() {
        return this.stream;
    }

    public ThreadRunRequest withStream(boolean stream) {
        return this.stream == stream ? this : new ThreadRunRequest(this.assistantId, this.model, this.instructions, this.additionalInstructions, this.tools, this.metadata, stream);
    }

    public static class ThreadRunRequestBuilder {
        private String assistantId;
        private String model;
        private String instructions;
        private String additionalInstructions;
        private ArrayList<AssistantTool> tools;
        private Map<String, String> metadata;
        private boolean stream;

        ThreadRunRequestBuilder() {
        }

        public ThreadRunRequestBuilder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public ThreadRunRequestBuilder model(String model) {
            this.model = model;
            return this;
        }

        public ThreadRunRequestBuilder instructions(String instructions) {
            this.instructions = instructions;
            return this;
        }

        public ThreadRunRequestBuilder additionalInstructions(String additionalInstructions) {
            this.additionalInstructions = additionalInstructions;
            return this;
        }

        public ThreadRunRequestBuilder tool(AssistantTool tool) {
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.add(tool);
            return this;
        }

        public ThreadRunRequestBuilder tools(Collection<? extends AssistantTool> tools) {
            if (tools == null) {
                throw new NullPointerException("tools cannot be null");
            }
            if (this.tools == null) {
                this.tools = new ArrayList();
            }
            this.tools.addAll(tools);
            return this;
        }

        public ThreadRunRequestBuilder clearTools() {
            if (this.tools != null) {
                this.tools.clear();
            }
            return this;
        }

        public ThreadRunRequestBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public ThreadRunRequestBuilder stream(boolean stream) {
            this.stream = stream;
            return this;
        }

        public ThreadRunRequest build() {
            List<AssistantTool> tools;
            switch (this.tools == null ? 0 : this.tools.size()) {
                case 0: {
                    tools = Collections.emptyList();
                    break;
                }
                case 1: {
                    tools = Collections.singletonList(this.tools.get(0));
                    break;
                }
                default: {
                    tools = Collections.unmodifiableList(new ArrayList<AssistantTool>(this.tools));
                }
            }
            return new ThreadRunRequest(this.assistantId, this.model, this.instructions, this.additionalInstructions, tools, this.metadata, this.stream);
        }

        public String toString() {
            return "ThreadRunRequest.ThreadRunRequestBuilder(assistantId=" + this.assistantId + ", model=" + this.model + ", instructions=" + this.instructions + ", additionalInstructions=" + this.additionalInstructions + ", tools=" + this.tools + ", metadata=" + this.metadata + ", stream=" + this.stream + ")";
        }
    }
}

