/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.function;

import io.github.sashirestela.cleverclient.util.CommonUtil;
import io.github.sashirestela.cleverclient.util.JsonUtil;
import io.github.sashirestela.openai.SimpleUncheckedException;
import io.github.sashirestela.openai.domain.ToolCall;
import io.github.sashirestela.openai.domain.assistant.ToolOutput;
import io.github.sashirestela.openai.domain.chat.tool.ChatFunction;
import io.github.sashirestela.openai.domain.chat.tool.ChatFunctionCall;
import io.github.sashirestela.openai.domain.chat.tool.ChatTool;
import io.github.sashirestela.openai.domain.chat.tool.ChatToolType;
import io.github.sashirestela.openai.function.Functional;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FunctionExecutor {
    private Map<String, ChatFunction> mapFunctions = new HashMap<String, ChatFunction>();

    public FunctionExecutor() {
    }

    public FunctionExecutor(List<ChatFunction> functions) {
        this.enrollFunctions(functions);
    }

    public List<ChatTool> getToolFunctions() {
        return this.mapFunctions.values().stream().map(func -> new ChatTool(ChatToolType.FUNCTION, (ChatFunction)func)).collect(Collectors.toList());
    }

    public void enrollFunction(ChatFunction function) {
        this.mapFunctions.put(function.getName(), function);
    }

    public void enrollFunctions(List<ChatFunction> functions) {
        if (functions == null) {
            throw new SimpleUncheckedException("No functions were entered.", "", null);
        }
        this.mapFunctions.clear();
        functions.forEach(function -> this.enrollFunction((ChatFunction)function));
    }

    public <T> T execute(ChatFunctionCall functionToCall) {
        if (functionToCall == null || CommonUtil.isNullOrEmpty((String)functionToCall.getName())) {
            throw new SimpleUncheckedException("No function was entered or it does not has a name.", "", null);
        }
        String functionName = functionToCall.getName();
        if (!this.mapFunctions.containsKey(functionName)) {
            throw new SimpleUncheckedException("The function {0} was not enrolled in the executor.", functionName, null);
        }
        try {
            ChatFunction function = this.mapFunctions.get(functionName);
            Functional object = (Functional)JsonUtil.jsonToObjectStrict((String)functionToCall.getArguments(), function.getFunctionalClass());
            return (T)object.execute();
        }
        catch (RuntimeException e) {
            throw new SimpleUncheckedException("Cannot execute the function {0}.", functionName, e);
        }
    }

    public List<ToolOutput> executeAll(List<ToolCall> toolsToCalls) {
        ArrayList<ToolOutput> toolOutputs = new ArrayList<ToolOutput>();
        for (ToolCall toolToCall : toolsToCalls) {
            if (toolToCall.getFunction() == null) continue;
            toolOutputs.add(this.execute(toolToCall.getId(), toolToCall.getFunction()));
        }
        return toolOutputs;
    }

    public ToolOutput execute(String toolCallId, ChatFunctionCall functionToCall) {
        try {
            return ToolOutput.of(toolCallId, "" + this.execute(functionToCall));
        }
        catch (Exception e) {
            return ToolOutput.of(toolCallId, e.toString());
        }
    }
}

