/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.chat;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.sashirestela.openai.domain.chat.ChatFunction;
import io.github.sashirestela.openai.domain.chat.ChatMessage;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class ChatRequest {
    @NonNull
    private String model;
    @NonNull
    private List<ChatMessage> messages;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<ChatFunction> functions;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="function_call")
    private String functionCall;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Double temperature;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="top_p")
    private Double topP;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Integer n;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private Boolean stream;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<String> stop;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="presence_penalty")
    private Double presencePenalty;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="frequency_penalty")
    private Double frequencyPenalty;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="logit_bias")
    private Map<String, Integer> logitBias;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String user;

    public static ChatRequestBuilder builder() {
        return new ChatRequestBuilder();
    }

    public ChatRequest(@NonNull String model, @NonNull List<ChatMessage> messages, List<ChatFunction> functions, String functionCall, Double temperature, Double topP, Integer n, Boolean stream, List<String> stop, Integer maxTokens, Double presencePenalty, Double frequencyPenalty, Map<String, Integer> logitBias, String user) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        if (messages == null) {
            throw new NullPointerException("messages is marked non-null but is null");
        }
        this.model = model;
        this.messages = messages;
        this.functions = functions;
        this.functionCall = functionCall;
        this.temperature = temperature;
        this.topP = topP;
        this.n = n;
        this.stream = stream;
        this.stop = stop;
        this.maxTokens = maxTokens;
        this.presencePenalty = presencePenalty;
        this.frequencyPenalty = frequencyPenalty;
        this.logitBias = logitBias;
        this.user = user;
    }

    @NonNull
    public String getModel() {
        return this.model;
    }

    @NonNull
    public List<ChatMessage> getMessages() {
        return this.messages;
    }

    public List<ChatFunction> getFunctions() {
        return this.functions;
    }

    public String getFunctionCall() {
        return this.functionCall;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Integer getN() {
        return this.n;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public Map<String, Integer> getLogitBias() {
        return this.logitBias;
    }

    public String getUser() {
        return this.user;
    }

    public static class ChatRequestBuilder {
        private String model;
        private List<ChatMessage> messages;
        private List<ChatFunction> functions;
        private String functionCall;
        private Double temperature;
        private Double topP;
        private Integer n;
        private Boolean stream;
        private List<String> stop;
        private Integer maxTokens;
        private Double presencePenalty;
        private Double frequencyPenalty;
        private Map<String, Integer> logitBias;
        private String user;

        ChatRequestBuilder() {
        }

        public ChatRequestBuilder model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model = model;
            return this;
        }

        public ChatRequestBuilder messages(@NonNull List<ChatMessage> messages) {
            if (messages == null) {
                throw new NullPointerException("messages is marked non-null but is null");
            }
            this.messages = messages;
            return this;
        }

        public ChatRequestBuilder functions(List<ChatFunction> functions) {
            this.functions = functions;
            return this;
        }

        @JsonProperty(value="function_call")
        public ChatRequestBuilder functionCall(String functionCall) {
            this.functionCall = functionCall;
            return this;
        }

        public ChatRequestBuilder temperature(Double temperature) {
            this.temperature = temperature;
            return this;
        }

        @JsonProperty(value="top_p")
        public ChatRequestBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public ChatRequestBuilder n(Integer n) {
            this.n = n;
            return this;
        }

        public ChatRequestBuilder stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        public ChatRequestBuilder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        @JsonProperty(value="max_tokens")
        public ChatRequestBuilder maxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
            return this;
        }

        @JsonProperty(value="presence_penalty")
        public ChatRequestBuilder presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this;
        }

        @JsonProperty(value="frequency_penalty")
        public ChatRequestBuilder frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        @JsonProperty(value="logit_bias")
        public ChatRequestBuilder logitBias(Map<String, Integer> logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        public ChatRequestBuilder user(String user) {
            this.user = user;
            return this;
        }

        public ChatRequest build() {
            return new ChatRequest(this.model, this.messages, this.functions, this.functionCall, this.temperature, this.topP, this.n, this.stream, this.stop, this.maxTokens, this.presencePenalty, this.frequencyPenalty, this.logitBias, this.user);
        }

        public String toString() {
            return "ChatRequest.ChatRequestBuilder(model=" + this.model + ", messages=" + this.messages + ", functions=" + this.functions + ", functionCall=" + this.functionCall + ", temperature=" + this.temperature + ", topP=" + this.topP + ", n=" + this.n + ", stream=" + this.stream + ", stop=" + this.stop + ", maxTokens=" + this.maxTokens + ", presencePenalty=" + this.presencePenalty + ", frequencyPenalty=" + this.frequencyPenalty + ", logitBias=" + this.logitBias + ", user=" + this.user + ")";
        }
    }
}

