/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.chat;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.sashirestela.openai.SimpleUncheckedException;
import io.github.sashirestela.openai.domain.chat.ChatFunctionCall;
import io.github.sashirestela.openai.domain.chat.Role;
import lombok.NonNull;

public class ChatMessage {
    @NonNull
    private Role role;
    private String content;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String name;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="function_call")
    private ChatFunctionCall functionCall;

    public ChatMessage(Role role, String content) {
        this.role = role;
        this.content = content;
        this.validate();
    }

    public ChatMessage(@NonNull Role role, String content, String name, ChatFunctionCall functionCall) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        this.role = role;
        this.content = content;
        this.name = name;
        this.functionCall = functionCall;
        this.validate();
    }

    private void validate() {
        if (this.role != Role.ASSISTANT && this.content == null) {
            throw new SimpleUncheckedException("The content is required for ChatMessage when role is other than assistant.", null, null);
        }
        if (this.role == Role.FUNCTION && this.name == null) {
            throw new SimpleUncheckedException("The name is required for ChatMessage when role is function.", null, null);
        }
    }

    public static ChatMessageBuilder builder() {
        return new ChatMessageBuilder();
    }

    public ChatMessage() {
    }

    @NonNull
    public Role getRole() {
        return this.role;
    }

    public String getContent() {
        return this.content;
    }

    public String getName() {
        return this.name;
    }

    public ChatFunctionCall getFunctionCall() {
        return this.functionCall;
    }

    public String toString() {
        return "ChatMessage(role=" + this.getRole() + ", content=" + this.getContent() + ", name=" + this.getName() + ", functionCall=" + this.getFunctionCall() + ")";
    }

    public static class ChatMessageBuilder {
        private Role role;
        private String content;
        private String name;
        private ChatFunctionCall functionCall;

        ChatMessageBuilder() {
        }

        public ChatMessageBuilder role(@NonNull Role role) {
            if (role == null) {
                throw new NullPointerException("role is marked non-null but is null");
            }
            this.role = role;
            return this;
        }

        public ChatMessageBuilder content(String content) {
            this.content = content;
            return this;
        }

        public ChatMessageBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ChatMessageBuilder functionCall(ChatFunctionCall functionCall) {
            this.functionCall = functionCall;
            return this;
        }

        public ChatMessage build() {
            return new ChatMessage(this.role, this.content, this.name, this.functionCall);
        }

        public String toString() {
            return "ChatMessage.ChatMessageBuilder(role=" + this.role + ", content=" + this.content + ", name=" + this.name + ", functionCall=" + this.functionCall + ")";
        }
    }
}

