/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.support;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.Option;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.github.victools.jsonschema.module.jackson.JacksonModule;
import com.github.victools.jsonschema.module.jackson.JacksonOption;
import io.github.sashirestela.openai.SimpleUncheckedException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class JsonUtil {
    private static JsonUtil jsonUtil = null;
    private ObjectMapper objectMapper = new ObjectMapper();

    private JsonUtil() {
    }

    public static JsonUtil get() {
        if (jsonUtil == null) {
            jsonUtil = new JsonUtil();
        }
        return jsonUtil;
    }

    public <T> String objectToJson(T object) {
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new SimpleUncheckedException("Cannot convert the object {0} to Json.", new Object[]{object, e});
        }
    }

    public <T> T jsonToObject(String json, Class<T> clazz) {
        try {
            return (T)this.objectMapper.readValue(json, clazz);
        }
        catch (JsonProcessingException e) {
            throw new SimpleUncheckedException("Cannot convert the Json {0} to class {1}.", new Object[]{json, clazz.getName(), e});
        }
    }

    public <T> List<T> jsonToList(String json, Class<T> clazz) {
        try {
            CollectionType listType = this.objectMapper.getTypeFactory().constructCollectionType(ArrayList.class, clazz);
            return (List)this.objectMapper.readValue(json, (JavaType)listType);
        }
        catch (JsonProcessingException e) {
            throw new SimpleUncheckedException("Cannot convert the Json {0} to List of {1}.", new Object[]{json, clazz.getName(), e});
        }
    }

    public <T, U> T jsonToParametricObject(String json, Class<T> clazzT, Class<U> clazzU) {
        try {
            JavaType javaType = this.objectMapper.getTypeFactory().constructParametricType(clazzT, new Class[]{clazzU});
            return (T)this.objectMapper.readValue(json, javaType);
        }
        catch (JsonProcessingException e) {
            throw new SimpleUncheckedException("Cannot convert the Json {0} to class of {1}.", new Object[]{json, clazzT.getName(), e});
        }
    }

    public JsonNode classToJsonSchema(Class<?> clazz) {
        JsonNode jsonSchema = null;
        if (clazz.getFields().length > 0) {
            try {
                JacksonModule jacksonModule = new JacksonModule(new JacksonOption[]{JacksonOption.RESPECT_JSONPROPERTY_REQUIRED});
                SchemaGeneratorConfigBuilder configBuilder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_2020_12, OptionPreset.PLAIN_JSON).with((Module)jacksonModule).without(Option.SCHEMA_VERSION_INDICATOR, new Option[0]);
                SchemaGeneratorConfig config = configBuilder.build();
                SchemaGenerator generator = new SchemaGenerator(config);
                jsonSchema = generator.generateSchema(clazz, new Type[0]);
            }
            catch (Exception e) {
                throw new SimpleUncheckedException("Cannot generate the Json Schema for the class {0}.", clazz.getName(), e);
            }
        }
        try {
            jsonSchema = this.objectMapper.readTree("{\"type\":\"object\",\"properties\":{}}");
        }
        catch (JsonProcessingException e) {
            throw new SimpleUncheckedException("Cannot generate the Json Schema for the class {0}.", new Object[]{clazz.getName(), e});
        }
        return jsonSchema;
    }
}

