/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.domain.finetuning;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.sashirestela.openai.domain.finetuning.HyperParams;
import lombok.NonNull;

public class FineTuningRequest {
    @JsonProperty(value="training_file")
    @NonNull
    private String trainingFile;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="validation_file")
    private String validationFile;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @NonNull
    private String model;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonProperty(value="hyperparameters")
    private HyperParams hyperParameters;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String suffix;

    public static FineTuningRequestBuilder builder() {
        return new FineTuningRequestBuilder();
    }

    public FineTuningRequest() {
    }

    public FineTuningRequest(@NonNull String trainingFile, String validationFile, @NonNull String model, HyperParams hyperParameters, String suffix) {
        if (trainingFile == null) {
            throw new NullPointerException("trainingFile is marked non-null but is null");
        }
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        this.trainingFile = trainingFile;
        this.validationFile = validationFile;
        this.model = model;
        this.hyperParameters = hyperParameters;
        this.suffix = suffix;
    }

    @NonNull
    public String getTrainingFile() {
        return this.trainingFile;
    }

    public String getValidationFile() {
        return this.validationFile;
    }

    @NonNull
    public String getModel() {
        return this.model;
    }

    public HyperParams getHyperParameters() {
        return this.hyperParameters;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String toString() {
        return "FineTuningRequest(trainingFile=" + this.getTrainingFile() + ", validationFile=" + this.getValidationFile() + ", model=" + this.getModel() + ", hyperParameters=" + this.getHyperParameters() + ", suffix=" + this.getSuffix() + ")";
    }

    public static class FineTuningRequestBuilder {
        private String trainingFile;
        private String validationFile;
        private String model;
        private HyperParams hyperParameters;
        private String suffix;

        FineTuningRequestBuilder() {
        }

        @JsonProperty(value="training_file")
        public FineTuningRequestBuilder trainingFile(@NonNull String trainingFile) {
            if (trainingFile == null) {
                throw new NullPointerException("trainingFile is marked non-null but is null");
            }
            this.trainingFile = trainingFile;
            return this;
        }

        @JsonProperty(value="validation_file")
        public FineTuningRequestBuilder validationFile(String validationFile) {
            this.validationFile = validationFile;
            return this;
        }

        public FineTuningRequestBuilder model(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model = model;
            return this;
        }

        @JsonProperty(value="hyperparameters")
        public FineTuningRequestBuilder hyperParameters(HyperParams hyperParameters) {
            this.hyperParameters = hyperParameters;
            return this;
        }

        public FineTuningRequestBuilder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public FineTuningRequest build() {
            return new FineTuningRequest(this.trainingFile, this.validationFile, this.model, this.hyperParameters, this.suffix);
        }

        public String toString() {
            return "FineTuningRequest.FineTuningRequestBuilder(trainingFile=" + this.trainingFile + ", validationFile=" + this.validationFile + ", model=" + this.model + ", hyperParameters=" + this.hyperParameters + ", suffix=" + this.suffix + ")";
        }
    }
}

