/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.openai.http.sender;

import io.github.sashirestela.openai.SimpleUncheckedException;
import io.github.sashirestela.openai.http.ReturnType;
import io.github.sashirestela.openai.http.sender.HttpAsyncListSender;
import io.github.sashirestela.openai.http.sender.HttpAsyncObjectSender;
import io.github.sashirestela.openai.http.sender.HttpAsyncPlainTextSender;
import io.github.sashirestela.openai.http.sender.HttpAsyncStreamSender;
import io.github.sashirestela.openai.http.sender.HttpSender;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSenderFactory {
    private static Logger LOGGER = LoggerFactory.getLogger(HttpSenderFactory.class);
    private static HttpSenderFactory factory = null;
    private Map<ReturnType.Category, Supplier<HttpSender>> sendersMap = new HashMap<ReturnType.Category, Supplier<HttpSender>>();

    private HttpSenderFactory() {
        this.sendersMap.put(ReturnType.Category.ASYNC_STREAM, () -> new HttpAsyncStreamSender());
        this.sendersMap.put(ReturnType.Category.ASYNC_LIST, () -> new HttpAsyncListSender());
        this.sendersMap.put(ReturnType.Category.ASYNC_OBJECT, () -> new HttpAsyncObjectSender());
        this.sendersMap.put(ReturnType.Category.ASYNC_PLAIN_TEXT, () -> new HttpAsyncPlainTextSender());
    }

    public static HttpSenderFactory get() {
        if (factory == null) {
            factory = new HttpSenderFactory();
        }
        return factory;
    }

    public HttpSender createSender(ReturnType returnType) {
        HttpSender sender = null;
        ReturnType.Category category = returnType.category();
        if (category == null || !this.sendersMap.containsKey((Object)category)) {
            throw new SimpleUncheckedException("Unsupported return type {0}.", returnType.getFullClassName(), null);
        }
        sender = this.sendersMap.get((Object)category).get();
        LOGGER.debug("Created Sender : {}", (Object)sender.getClass().getSimpleName());
        return sender;
    }
}

