/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.retry;

import io.github.sashirestela.cleverclient.retry.RetryConfig;
import io.github.sashirestela.cleverclient.support.CleverClientException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryableRequest {
    private static final Logger logger = LoggerFactory.getLogger(RetryableRequest.class);
    private final RetryConfig config;
    private final Random random;

    public RetryableRequest(RetryConfig config) {
        this.config = config;
        this.random = new SecureRandom();
    }

    public <T> T execute(Supplier<T> operation) {
        int attempt;
        Exception lastException = null;
        logger.debug("Calling (attempt {}/{}).", (Object)attempt, (Object)this.config.getMaxAttempts());
        for (attempt = 1; attempt <= this.config.getMaxAttempts(); ++attempt) {
            try {
                return operation.get();
            }
            catch (Exception e) {
                lastException = e;
                if (!this.isRetryable(e) || attempt == this.config.getMaxAttempts()) break;
                long delayMs = this.calculateDelayWithJitter(attempt);
                logger.debug("Calling (attempt {}/{}). Retrying in {} ms", new Object[]{attempt + 1, this.config.getMaxAttempts(), delayMs});
                try {
                    Thread.sleep(delayMs);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
        }
        throw new CleverClientException("Calling failed after " + attempt + " attempts", new Object[]{lastException});
    }

    public <T> CompletableFuture<T> executeAsync(Supplier<Object> operation) {
        CompletableFuture future = new CompletableFuture();
        logger.debug("Calling (attempt {}/{}).", (Object)1, (Object)this.config.getMaxAttempts());
        this.executeAsyncAttempt(operation, 1, future);
        return future;
    }

    private <T> void executeAsyncAttempt(Supplier<Object> operation, int attempt, CompletableFuture<T> resultFuture) {
        ((CompletableFuture)operation.get()).handle((result, error) -> {
            if (error == null) {
                resultFuture.complete(result);
                return null;
            }
            if (!this.isRetryable((Throwable)error) || attempt >= this.config.getMaxAttempts()) {
                resultFuture.completeExceptionally(new CleverClientException("Calling failed after " + attempt + " attempts", error));
                return null;
            }
            long delayMs = this.calculateDelayWithJitter(attempt);
            logger.debug("Calling (attempt {}/{}). Retrying in {} ms", new Object[]{attempt + 1, this.config.getMaxAttempts(), delayMs});
            CompletableFuture.delayedExecutor(delayMs, TimeUnit.MILLISECONDS).execute(() -> this.lambda$executeAsyncAttempt$0((Supplier)operation, attempt, resultFuture));
            return null;
        });
    }

    private boolean isRetryable(Throwable exception) {
        Throwable theException;
        Throwable throwable = exception = exception instanceof CompletionException ? exception.getCause() : exception;
        if (exception == null) {
            return false;
        }
        Throwable throwable2 = theException = exception instanceof CleverClientException ? exception.getCause() : exception;
        if (theException != null) {
            return Arrays.stream(this.config.getRetryableExceptions()).anyMatch(retryable -> retryable.isInstance(theException));
        }
        return ((CleverClientException)exception).responseInfo().map(respInfo -> Arrays.stream(this.config.getRetryableStatusCodes()).anyMatch(range -> ((int[])range).length == 1 ? respInfo.getStatusCode() == range[0] : respInfo.getStatusCode() >= range[0] && respInfo.getStatusCode() <= range[1])).orElse(false);
    }

    private long calculateDelayWithJitter(int attempt) {
        double multiplier = Math.pow(this.config.getBackoffMultiplier(), (double)attempt - 1.0);
        long baseDelay = (long)((double)this.config.getInitialDelayMs() * multiplier);
        baseDelay = Math.min(baseDelay, this.config.getMaxDelayMs());
        if (this.config.getJitterFactor() > 0.0) {
            long jitterRange = (long)((double)baseDelay * this.config.getJitterFactor());
            long halfRange = jitterRange / 2L;
            long jitter = -halfRange + this.random.nextLong() % (halfRange + 1L);
            baseDelay = Math.max(0L, baseDelay + jitter);
            baseDelay = Math.min(baseDelay, this.config.getMaxDelayMs());
        }
        return baseDelay;
    }

    private /* synthetic */ void lambda$executeAsyncAttempt$0(Supplier operation, int attempt, CompletableFuture resultFuture) {
        this.executeAsyncAttempt(operation, attempt + 1, resultFuture);
    }
}

