/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.client;

import io.github.sashirestela.cleverclient.Event;
import io.github.sashirestela.cleverclient.ResponseInfo;
import io.github.sashirestela.cleverclient.client.RequestData;
import io.github.sashirestela.cleverclient.client.ResponseData;
import io.github.sashirestela.cleverclient.http.HttpRequestData;
import io.github.sashirestela.cleverclient.http.HttpResponseData;
import io.github.sashirestela.cleverclient.retry.RetryableRequest;
import io.github.sashirestela.cleverclient.support.CleverClientException;
import io.github.sashirestela.cleverclient.support.CleverClientSSE;
import io.github.sashirestela.cleverclient.support.ReturnType;
import io.github.sashirestela.cleverclient.util.CommonUtil;
import io.github.sashirestela.cleverclient.util.JsonUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpClientAdapter {
    private static Logger logger = LoggerFactory.getLogger(HttpClientAdapter.class);
    protected static final String REQUEST_BODY_FORMAT = "Request Body : {}";
    protected static final String RESPONSE_CODE_FORMAT = "Response Code : {}";
    protected static final String RESPONSE_FORMAT = "Response : {}";
    protected UnaryOperator<HttpRequestData> requestInterceptor;
    protected UnaryOperator<HttpResponseData> responseInterceptor;
    protected RetryableRequest retryableRequest;

    public Object sendRequest(RequestData originalRequest) {
        RequestData actualRequest = this.interceptRequest(originalRequest);
        logger.debug("Http Call : {} {}", (Object)actualRequest.getHttpMethod(), (Object)actualRequest.getUrl());
        String formattedHeaders = this.formattedHeaders(actualRequest.getHeaders());
        logger.debug("Request Headers : {}", (Object)formattedHeaders);
        if (this.retryableRequest == null) {
            if (actualRequest.getReturnType().isAsync()) {
                return this.sendAsync(actualRequest);
            }
            return this.send(actualRequest);
        }
        if (actualRequest.getReturnType().isAsync()) {
            return this.retryableRequest.executeAsync(() -> this.sendAsync(actualRequest));
        }
        return this.retryableRequest.execute(() -> this.send(actualRequest));
    }

    protected abstract Object sendAsync(RequestData var1);

    protected abstract Object send(RequestData var1);

    public abstract void shutdown();

    private RequestData interceptRequest(RequestData originalRequest) {
        if (this.requestInterceptor != null) {
            HttpRequestData httpRequestData = originalRequest.getHttpRequestData();
            httpRequestData = (HttpRequestData)this.requestInterceptor.apply(httpRequestData);
            return originalRequest.withUrl(httpRequestData.getUrl()).withBody(httpRequestData.getBody()).withHeaders(CommonUtil.mapToListOfString(httpRequestData.getHeaders()));
        }
        return originalRequest;
    }

    protected ResponseData interceptResponse(ResponseData originalResponse) {
        if (this.responseInterceptor != null && originalResponse.getBody() instanceof String) {
            HttpResponseData httpResponseData = originalResponse.getHttpResponseData();
            httpResponseData = (HttpResponseData)this.responseInterceptor.apply(httpResponseData);
            return originalResponse.withBody(httpResponseData.getBody());
        }
        return originalResponse;
    }

    protected void throwExceptionIfErrorIsPresent(ResponseData response) {
        if (!CommonUtil.isInHundredsOf(response.getStatusCode(), 200)) {
            String data = "";
            if (response.getBody() instanceof Stream) {
                data = ((Stream)response.getBody()).collect(Collectors.joining(System.getProperty("line.separator")));
            } else if (response.getBody() instanceof InputStream) {
                try {
                    data = new String(((InputStream)response.getBody()).readAllBytes(), StandardCharsets.UTF_8);
                }
                catch (IOException e) {
                    throw new CleverClientException(e);
                }
            } else {
                data = (String)response.getBody();
            }
            logger.error(RESPONSE_FORMAT, (Object)data);
            throw new CleverClientException(this.fillResponseInfo(response, data));
        }
    }

    private ResponseInfo fillResponseInfo(ResponseData response, String data) {
        ResponseData.Request request = response.getRequest();
        return ResponseInfo.builder().statusCode(response.getStatusCode()).data(data).headers(response.getHeaders()).request(request != null ? ResponseInfo.RequestInfo.builder().httpMethod(request.getHttpMethod()).url(request.getUrl()).headers(request.getHeaders()).build() : null).build();
    }

    private String formattedHeaders(List<String> headers) {
        String RESERVED_REGEX = "(authorization|api.?key)";
        Pattern pattern = Pattern.compile("(authorization|api.?key)", 2);
        StringBuilder print = new StringBuilder("{");
        for (int i = 0; i < headers.size(); i += 2) {
            String headerKey;
            Matcher matcher;
            if (i > 1) {
                print.append(", ");
            }
            String headerVal = (matcher = pattern.matcher(headerKey = headers.get(i))).find() ? "*".repeat(10) : headers.get(i + 1);
            print.append(headerKey + " = " + headerVal);
        }
        print.append("}");
        return print.toString();
    }

    protected Stream<Object> convertToStreamOfObjects(ResponseData responseData, ReturnType returnType) {
        CleverClientSSE.LineRecord lineRecord = new CleverClientSSE.LineRecord();
        return ((Stream)responseData.getBody()).map(line -> {
            logger.debug(RESPONSE_FORMAT, line);
            lineRecord.updateWith((String)line);
            return new CleverClientSSE(lineRecord);
        }).filter(CleverClientSSE::isActualData).map(item -> JsonUtil.jsonToObject(this.interceptStreamItem(responseData, item.getActualData()), returnType.getBaseClass()));
    }

    protected Stream<Object> convertToStreamOfEvents(ResponseData responseData, ReturnType returnType) {
        CleverClientSSE.LineRecord lineRecord = new CleverClientSSE.LineRecord();
        Set<String> events = returnType.getClassByEvent().keySet();
        return ((Stream)responseData.getBody()).map(line -> {
            logger.debug(RESPONSE_FORMAT, line);
            lineRecord.updateWith((String)line);
            return new CleverClientSSE(lineRecord, events);
        }).filter(CleverClientSSE::isActualData).map(item -> Event.builder().name(item.getMatchedEvent()).data(JsonUtil.jsonToObject(this.interceptStreamItem(responseData, item.getActualData()), returnType.getClassByEvent().get(item.getMatchedEvent()))).build());
    }

    private String interceptStreamItem(ResponseData responseData, String text) {
        if (this.responseInterceptor == null) {
            return text;
        }
        HttpResponseData httpResponseData = responseData.getHttpResponseData(text);
        httpResponseData = (HttpResponseData)this.responseInterceptor.apply(httpResponseData);
        return httpResponseData.getBody();
    }

    @Generated
    public void setRequestInterceptor(UnaryOperator<HttpRequestData> requestInterceptor) {
        this.requestInterceptor = requestInterceptor;
    }

    @Generated
    public void setResponseInterceptor(UnaryOperator<HttpResponseData> responseInterceptor) {
        this.responseInterceptor = responseInterceptor;
    }

    @Generated
    public void setRetryableRequest(RetryableRequest retryableRequest) {
        this.retryableRequest = retryableRequest;
    }
}

