/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.client;

import io.github.sashirestela.cleverclient.client.HttpClientAdapter;
import io.github.sashirestela.cleverclient.client.RequestData;
import io.github.sashirestela.cleverclient.client.ResponseData;
import io.github.sashirestela.cleverclient.support.CleverClientException;
import io.github.sashirestela.cleverclient.support.ContentType;
import io.github.sashirestela.cleverclient.support.HttpMultipart;
import io.github.sashirestela.cleverclient.support.ReturnType;
import io.github.sashirestela.cleverclient.util.JsonUtil;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaHttpClientAdapter
extends HttpClientAdapter {
    private static Logger logger = LoggerFactory.getLogger(JavaHttpClientAdapter.class);
    private HttpClient httpClient;
    private EnumMap<ReturnType.Category, FunctionsByCategory> functionsByCategoryMap;

    public JavaHttpClientAdapter(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.fillFunctionsByCategory();
    }

    public JavaHttpClientAdapter() {
        this(HttpClient.newHttpClient());
    }

    public HttpClient getJavaHttpClient() {
        return this.httpClient;
    }

    @Override
    protected Object send(RequestData request) {
        ReturnType returnType = request.getReturnType();
        FunctionsByCategory functions = this.getFunctions(returnType);
        HttpRequest httpRequest = this.convertToHttpRequest(request);
        try {
            HttpResponse<?> httpResponse = this.httpClient.send(httpRequest, functions.bodyHandler.get());
            logger.debug("Response Code : {}", (Object)httpResponse.statusCode());
            ResponseData originalResponseData = this.convertToResponseData(httpResponse);
            this.throwExceptionIfErrorIsPresent(originalResponseData);
            ResponseData responseData = this.interceptResponse(originalResponseData);
            if (!returnType.isStream()) {
                logger.debug("Response : {}", responseData.getBody());
                return functions.responseConverter.apply(responseData.getBody(), returnType);
            }
            return functions.responseConverter.apply(responseData, returnType);
        }
        catch (IOException | InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CleverClientException(e);
        }
    }

    @Override
    protected Object sendAsync(RequestData request) {
        ReturnType returnType = request.getReturnType();
        FunctionsByCategory functions = this.getFunctions(returnType);
        HttpRequest httpRequest = this.convertToHttpRequest(request);
        CompletableFuture<HttpResponse<?>> httpResponseFuture = this.httpClient.sendAsync(httpRequest, functions.bodyHandler.get());
        return httpResponseFuture.thenApply(httpResponse -> {
            logger.debug("Response Code : {}", (Object)httpResponse.statusCode());
            ResponseData originalResponseData = this.convertToResponseData((HttpResponse<?>)httpResponse);
            this.throwExceptionIfErrorIsPresent(originalResponseData);
            ResponseData responseData = this.interceptResponse(originalResponseData);
            if (!returnType.isStream()) {
                logger.debug("Response : {}", responseData.getBody());
                return functions.responseConverter.apply(responseData.getBody(), returnType);
            }
            return functions.responseConverter.apply(responseData, returnType);
        });
    }

    @Override
    public void shutdown() {
        this.httpClient.executor().ifPresent(executor -> {
            if (executor instanceof ExecutorService) {
                ((ExecutorService)executor).shutdown();
            }
        });
    }

    private FunctionsByCategory getFunctions(ReturnType returnType) {
        FunctionsByCategory functions = this.functionsByCategoryMap.get((Object)returnType.category());
        if (functions == null) {
            throw new CleverClientException("Unsupported return type {0}.", returnType.getFullClassName(), null);
        }
        return functions;
    }

    private HttpRequest convertToHttpRequest(RequestData request) {
        HttpRequest.BodyPublisher bodyPublisher = this.createBodyPublisher(request.getBody(), request.getContentType());
        String[] headersArray = request.getHeaders().toArray(new String[0]);
        HttpRequest.Builder httpRequestBuilder = HttpRequest.newBuilder().uri(URI.create(request.getUrl())).method(request.getHttpMethod(), bodyPublisher);
        if (headersArray.length > 0) {
            httpRequestBuilder.headers(headersArray);
        }
        return httpRequestBuilder.build();
    }

    private HttpRequest.BodyPublisher createBodyPublisher(Object bodyObject, ContentType contentType) {
        HttpRequest.BodyPublisher bodyPublisher = null;
        if (contentType == null) {
            logger.debug("Request Body : {}", (Object)"(Empty)");
            bodyPublisher = HttpRequest.BodyPublishers.noBody();
        } else if (contentType == ContentType.MULTIPART_FORMDATA) {
            logger.debug("Request Body : {}", bodyObject);
            List<byte[]> bodyBytes = HttpMultipart.toByteArrays((Map)bodyObject);
            bodyPublisher = HttpRequest.BodyPublishers.ofByteArrays(bodyBytes);
        } else if (contentType == ContentType.APPLICATION_JSON) {
            logger.debug("Request Body : {}", bodyObject);
            bodyPublisher = HttpRequest.BodyPublishers.ofString((String)bodyObject);
        }
        return bodyPublisher;
    }

    private ResponseData convertToResponseData(HttpResponse<?> httpResponse) {
        HttpRequest httpRequest = httpResponse.request();
        return ResponseData.builder().statusCode(httpResponse.statusCode()).body(httpResponse.body()).headers(httpResponse.headers().map()).request(httpRequest != null ? ResponseData.Request.builder().httpMethod(httpRequest.method()).url(httpRequest.uri().toString()).headers(httpRequest.headers().map()).build() : null).build();
    }

    private void fillFunctionsByCategory() {
        this.functionsByCategoryMap = new EnumMap(ReturnType.Category.class);
        this.functionsByCategoryMap.put(ReturnType.Category.SYNC_BINARY, new FunctionsByCategory(() -> HttpResponse.BodyHandlers.ofInputStream(), (r, t) -> r));
        this.functionsByCategoryMap.put(ReturnType.Category.SYNC_PLAIN_TEXT, new FunctionsByCategory(() -> HttpResponse.BodyHandlers.ofString(), (r, t) -> r));
        this.functionsByCategoryMap.put(ReturnType.Category.SYNC_CUSTOM, new FunctionsByCategory(() -> HttpResponse.BodyHandlers.ofString(), (r, t) -> JsonUtil.jsonToObject((String)r, t.getBaseClass())));
        this.functionsByCategoryMap.put(ReturnType.Category.SYNC_GENERIC, new FunctionsByCategory(() -> HttpResponse.BodyHandlers.ofString(), (r, t) -> JsonUtil.jsonToParametricObject((String)r, t.getGenericClassIfExists(), t.getBaseClass())));
        this.functionsByCategoryMap.put(ReturnType.Category.SYNC_LIST, new FunctionsByCategory(() -> HttpResponse.BodyHandlers.ofString(), (r, t) -> JsonUtil.jsonToList((String)r, t.getBaseClass())));
        this.functionsByCategoryMap.put(ReturnType.Category.SYNC_STREAM, new FunctionsByCategory(() -> HttpResponse.BodyHandlers.ofLines(), (r, t) -> this.convertToStreamOfObjects((ResponseData)r, (ReturnType)t)));
        this.functionsByCategoryMap.put(ReturnType.Category.SYNC_STREAM_EVENT, new FunctionsByCategory(() -> HttpResponse.BodyHandlers.ofLines(), (r, t) -> this.convertToStreamOfEvents((ResponseData)r, (ReturnType)t)));
        this.functionsByCategoryMap.put(ReturnType.Category.ASYNC_BINARY, new FunctionsByCategory(() -> HttpResponse.BodyHandlers.ofInputStream(), (r, t) -> r));
        this.functionsByCategoryMap.put(ReturnType.Category.ASYNC_PLAIN_TEXT, new FunctionsByCategory(() -> HttpResponse.BodyHandlers.ofString(), (r, t) -> r));
        this.functionsByCategoryMap.put(ReturnType.Category.ASYNC_CUSTOM, new FunctionsByCategory(() -> HttpResponse.BodyHandlers.ofString(), (r, t) -> JsonUtil.jsonToObject((String)r, t.getBaseClass())));
        this.functionsByCategoryMap.put(ReturnType.Category.ASYNC_GENERIC, new FunctionsByCategory(() -> HttpResponse.BodyHandlers.ofString(), (r, t) -> JsonUtil.jsonToParametricObject((String)r, t.getGenericClassIfExists(), t.getBaseClass())));
        this.functionsByCategoryMap.put(ReturnType.Category.ASYNC_LIST, new FunctionsByCategory(() -> HttpResponse.BodyHandlers.ofString(), (r, t) -> JsonUtil.jsonToList((String)r, t.getBaseClass())));
        this.functionsByCategoryMap.put(ReturnType.Category.ASYNC_STREAM, new FunctionsByCategory(() -> HttpResponse.BodyHandlers.ofLines(), (r, t) -> this.convertToStreamOfObjects((ResponseData)r, (ReturnType)t)));
        this.functionsByCategoryMap.put(ReturnType.Category.ASYNC_STREAM_EVENT, new FunctionsByCategory(() -> HttpResponse.BodyHandlers.ofLines(), (r, t) -> this.convertToStreamOfEvents((ResponseData)r, (ReturnType)t)));
    }

    private class FunctionsByCategory {
        Supplier<HttpResponse.BodyHandler<?>> bodyHandler;
        BiFunction<Object, ReturnType, Object> responseConverter;

        public FunctionsByCategory(Supplier<HttpResponse.BodyHandler<?>> bodyHandler, BiFunction<Object, ReturnType, Object> responseConverter) {
            this.bodyHandler = bodyHandler;
            this.responseConverter = responseConverter;
        }
    }
}

