/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.support;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public class CleverClientException
extends RuntimeException {
    private final HttpResponseInfo responseInfo;

    public CleverClientException(String message) {
        super(message);
        this.responseInfo = null;
    }

    public CleverClientException(Throwable cause) {
        super(cause);
        this.responseInfo = null;
    }

    public CleverClientException(String message, Object ... parameters) {
        super(MessageFormat.format(message, Arrays.copyOfRange(parameters, 0, parameters.length - 1)), (Throwable)parameters[parameters.length - 1]);
        this.responseInfo = null;
    }

    public CleverClientException(HttpResponseInfo responseInfo) {
        super(MessageFormat.format("HTTP interaction failed: server returned a {0} response status.", responseInfo.getStatusCode()), null);
        this.responseInfo = responseInfo;
    }

    public Optional<HttpResponseInfo> responseInfo() {
        return Optional.ofNullable(this.responseInfo);
    }

    public static Optional<CleverClientException> getFrom(Throwable exception) {
        if (exception instanceof CleverClientException) {
            return Optional.of((CleverClientException)exception);
        }
        if (exception.getCause() instanceof CleverClientException) {
            return Optional.of((CleverClientException)exception.getCause());
        }
        return Optional.empty();
    }

    public static class HttpResponseInfo
    implements Serializable {
        private int statusCode;
        private String data;
        private Map<String, List<String>> headers;
        private HttpRequestInfo request;

        @Generated
        HttpResponseInfo(int statusCode, String data, Map<String, List<String>> headers, HttpRequestInfo request) {
            this.statusCode = statusCode;
            this.data = data;
            this.headers = headers;
            this.request = request;
        }

        @Generated
        public static HttpResponseInfoBuilder builder() {
            return new HttpResponseInfoBuilder();
        }

        @Generated
        public int getStatusCode() {
            return this.statusCode;
        }

        @Generated
        public String getData() {
            return this.data;
        }

        @Generated
        public Map<String, List<String>> getHeaders() {
            return this.headers;
        }

        @Generated
        public HttpRequestInfo getRequest() {
            return this.request;
        }

        @Generated
        public void setStatusCode(int statusCode) {
            this.statusCode = statusCode;
        }

        @Generated
        public void setData(String data) {
            this.data = data;
        }

        @Generated
        public void setHeaders(Map<String, List<String>> headers) {
            this.headers = headers;
        }

        @Generated
        public void setRequest(HttpRequestInfo request) {
            this.request = request;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HttpResponseInfo)) {
                return false;
            }
            HttpResponseInfo other = (HttpResponseInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getStatusCode() != other.getStatusCode()) {
                return false;
            }
            String this$data = this.getData();
            String other$data = other.getData();
            if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                return false;
            }
            Map<String, List<String>> this$headers = this.getHeaders();
            Map<String, List<String>> other$headers = other.getHeaders();
            if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
                return false;
            }
            HttpRequestInfo this$request = this.getRequest();
            HttpRequestInfo other$request = other.getRequest();
            return !(this$request == null ? other$request != null : !((Object)this$request).equals(other$request));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof HttpResponseInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getStatusCode();
            String $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            Map<String, List<String>> $headers = this.getHeaders();
            result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
            HttpRequestInfo $request = this.getRequest();
            result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "CleverClientException.HttpResponseInfo(statusCode=" + this.getStatusCode() + ", data=" + this.getData() + ", headers=" + this.getHeaders() + ", request=" + this.getRequest() + ")";
        }

        @Generated
        public static class HttpResponseInfoBuilder {
            @Generated
            private int statusCode;
            @Generated
            private String data;
            @Generated
            private Map<String, List<String>> headers;
            @Generated
            private HttpRequestInfo request;

            @Generated
            HttpResponseInfoBuilder() {
            }

            @Generated
            public HttpResponseInfoBuilder statusCode(int statusCode) {
                this.statusCode = statusCode;
                return this;
            }

            @Generated
            public HttpResponseInfoBuilder data(String data) {
                this.data = data;
                return this;
            }

            @Generated
            public HttpResponseInfoBuilder headers(Map<String, List<String>> headers) {
                this.headers = headers;
                return this;
            }

            @Generated
            public HttpResponseInfoBuilder request(HttpRequestInfo request) {
                this.request = request;
                return this;
            }

            @Generated
            public HttpResponseInfo build() {
                return new HttpResponseInfo(this.statusCode, this.data, this.headers, this.request);
            }

            @Generated
            public String toString() {
                return "CleverClientException.HttpResponseInfo.HttpResponseInfoBuilder(statusCode=" + this.statusCode + ", data=" + this.data + ", headers=" + this.headers + ", request=" + this.request + ")";
            }
        }

        public static class HttpRequestInfo
        implements Serializable {
            private String httpMethod;
            private String url;
            private Map<String, List<String>> headers;

            @Generated
            HttpRequestInfo(String httpMethod, String url, Map<String, List<String>> headers) {
                this.httpMethod = httpMethod;
                this.url = url;
                this.headers = headers;
            }

            @Generated
            public static HttpRequestInfoBuilder builder() {
                return new HttpRequestInfoBuilder();
            }

            @Generated
            public String getHttpMethod() {
                return this.httpMethod;
            }

            @Generated
            public String getUrl() {
                return this.url;
            }

            @Generated
            public Map<String, List<String>> getHeaders() {
                return this.headers;
            }

            @Generated
            public void setHttpMethod(String httpMethod) {
                this.httpMethod = httpMethod;
            }

            @Generated
            public void setUrl(String url) {
                this.url = url;
            }

            @Generated
            public void setHeaders(Map<String, List<String>> headers) {
                this.headers = headers;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof HttpRequestInfo)) {
                    return false;
                }
                HttpRequestInfo other = (HttpRequestInfo)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$httpMethod = this.getHttpMethod();
                String other$httpMethod = other.getHttpMethod();
                if (this$httpMethod == null ? other$httpMethod != null : !this$httpMethod.equals(other$httpMethod)) {
                    return false;
                }
                String this$url = this.getUrl();
                String other$url = other.getUrl();
                if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                    return false;
                }
                Map<String, List<String>> this$headers = this.getHeaders();
                Map<String, List<String>> other$headers = other.getHeaders();
                return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof HttpRequestInfo;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $httpMethod = this.getHttpMethod();
                result = result * 59 + ($httpMethod == null ? 43 : $httpMethod.hashCode());
                String $url = this.getUrl();
                result = result * 59 + ($url == null ? 43 : $url.hashCode());
                Map<String, List<String>> $headers = this.getHeaders();
                result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "CleverClientException.HttpResponseInfo.HttpRequestInfo(httpMethod=" + this.getHttpMethod() + ", url=" + this.getUrl() + ", headers=" + this.getHeaders() + ")";
            }

            @Generated
            public static class HttpRequestInfoBuilder {
                @Generated
                private String httpMethod;
                @Generated
                private String url;
                @Generated
                private Map<String, List<String>> headers;

                @Generated
                HttpRequestInfoBuilder() {
                }

                @Generated
                public HttpRequestInfoBuilder httpMethod(String httpMethod) {
                    this.httpMethod = httpMethod;
                    return this;
                }

                @Generated
                public HttpRequestInfoBuilder url(String url) {
                    this.url = url;
                    return this;
                }

                @Generated
                public HttpRequestInfoBuilder headers(Map<String, List<String>> headers) {
                    this.headers = headers;
                    return this;
                }

                @Generated
                public HttpRequestInfo build() {
                    return new HttpRequestInfo(this.httpMethod, this.url, this.headers);
                }

                @Generated
                public String toString() {
                    return "CleverClientException.HttpResponseInfo.HttpRequestInfo.HttpRequestInfoBuilder(httpMethod=" + this.httpMethod + ", url=" + this.url + ", headers=" + this.headers + ")";
                }
            }
        }
    }
}

