/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.http;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.github.sashirestela.cleverclient.metadata.InterfaceMetadata;
import io.github.sashirestela.cleverclient.support.CleverClientException;
import io.github.sashirestela.cleverclient.util.CommonUtil;
import io.github.sashirestela.cleverclient.util.JsonUtil;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

public class URLBuilder {
    private static URLBuilder urlBuilder = null;

    private URLBuilder() {
    }

    public static URLBuilder one() {
        if (urlBuilder == null) {
            urlBuilder = new URLBuilder();
        }
        return urlBuilder;
    }

    public String build(String urlMethod, InterfaceMetadata.MethodMetadata methodMetadata, Object[] arguments) {
        String url = urlMethod;
        List<InterfaceMetadata.ParameterMetadata> pathParameters = methodMetadata.getPathParameters();
        List<InterfaceMetadata.ParameterMetadata> queryParameters = methodMetadata.getQueryParameters();
        if (pathParameters.isEmpty() && queryParameters.isEmpty()) {
            return url;
        }
        url = this.replacePathParams(url, pathParameters, arguments);
        url = this.includeQueryParams(url, queryParameters, arguments);
        return url;
    }

    private String replacePathParams(String url, List<InterfaceMetadata.ParameterMetadata> pathParameters, Object[] arguments) {
        for (InterfaceMetadata.ParameterMetadata parameter : pathParameters) {
            int index = parameter.getIndex();
            String pathParam = "{" + parameter.getAnnotation().getValue() + "}";
            url = url.replace(pathParam, arguments[index].toString());
        }
        return url;
    }

    private String includeQueryParams(String url, List<InterfaceMetadata.ParameterMetadata> queryParameters, Object[] arguments) {
        StringBuilder queryParamBuilder = new StringBuilder();
        for (InterfaceMetadata.ParameterMetadata parameter : queryParameters) {
            String queryParam;
            int index = parameter.getIndex();
            Object value = arguments[index];
            if (value == null) continue;
            if (value instanceof Enum) {
                value = this.getEnumValue(value);
            }
            if (CommonUtil.isNullOrEmpty(queryParam = parameter.getAnnotation().getValue())) {
                this.appendQueryParams(JsonUtil.objectToMap(value), queryParamBuilder);
                continue;
            }
            this.appendQueryParam(queryParam, value, queryParamBuilder);
        }
        return url + queryParamBuilder;
    }

    private String getEnumValue(Object value) {
        Class<?> clazz = value.getClass();
        String enumValue = ((Enum)value).name();
        try {
            Field enumField = clazz.getField(enumValue);
            boolean hasJsonPropertyAnnotation = enumField.isAnnotationPresent(JsonProperty.class);
            if (hasJsonPropertyAnnotation) {
                return enumField.getAnnotation(JsonProperty.class).value();
            }
            return enumValue;
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new CleverClientException("Cannot get the enum field for the enum value {0}", enumValue, e);
        }
    }

    private void appendQueryParams(Map<String, ?> queryParams, StringBuilder queryParamBuilder) {
        queryParams.forEach((k, v) -> this.appendQueryParam((String)k, v, queryParamBuilder));
    }

    private void appendQueryParam(String name, Object value, StringBuilder queryParamBuilder) {
        if (value != null) {
            queryParamBuilder.append(queryParamBuilder.length() == 0 ? (char)'?' : '&').append(URLEncoder.encode(name, StandardCharsets.UTF_8)).append('=').append(URLEncoder.encode(value.toString(), StandardCharsets.UTF_8));
        }
    }
}

