/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.http;

import io.github.sashirestela.cleverclient.metadata.InterfaceMetadata;
import io.github.sashirestela.cleverclient.util.JsonUtil;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

public class URLBuilder {
    private static URLBuilder urlBuilder = null;

    private URLBuilder() {
    }

    public static URLBuilder one() {
        if (urlBuilder == null) {
            urlBuilder = new URLBuilder();
        }
        return urlBuilder;
    }

    public String build(String urlMethod, InterfaceMetadata.MethodMetadata methodMetadata, Object[] arguments) {
        String url = urlMethod;
        List<InterfaceMetadata.ParameterMetadata> pathParameters = methodMetadata.getPathParameters();
        List<InterfaceMetadata.ParameterMetadata> queryParameters = methodMetadata.getQueryParameters();
        if (pathParameters.isEmpty() && queryParameters.isEmpty()) {
            return url;
        }
        url = this.replacePathParams(url, pathParameters, arguments);
        url = this.includeQueryParams(url, queryParameters, arguments);
        return url;
    }

    private String replacePathParams(String url, List<InterfaceMetadata.ParameterMetadata> pathParameters, Object[] arguments) {
        for (InterfaceMetadata.ParameterMetadata parameter : pathParameters) {
            int index = parameter.getIndex();
            String pathParam = "{" + parameter.getAnnotation().getValue() + "}";
            url = url.replace(pathParam, arguments[index].toString());
        }
        return url;
    }

    private String includeQueryParams(String url, List<InterfaceMetadata.ParameterMetadata> queryParameters, Object[] arguments) {
        StringBuilder queryParamBuilder = new StringBuilder();
        for (InterfaceMetadata.ParameterMetadata parameter : queryParameters) {
            int index = parameter.getIndex();
            Object value = arguments[index];
            if (value == null) continue;
            String queryParam = parameter.getAnnotation().getValue();
            if (queryParam == null || queryParam.isEmpty()) {
                this.appendQueryParams(JsonUtil.objectToMap(value), queryParamBuilder);
                continue;
            }
            this.appendQueryParam(queryParam, value, queryParamBuilder);
        }
        return url + queryParamBuilder;
    }

    private void appendQueryParams(Map<String, ?> queryParams, StringBuilder queryParamBuilder) {
        queryParams.forEach((k, v) -> this.appendQueryParam((String)k, v, queryParamBuilder));
    }

    private void appendQueryParam(String name, Object value, StringBuilder queryParamBuilder) {
        if (value != null) {
            queryParamBuilder.append(queryParamBuilder.length() == 0 ? (char)'?' : '&').append(URLEncoder.encode(name, StandardCharsets.UTF_8)).append('=').append(URLEncoder.encode(value.toString(), StandardCharsets.UTF_8));
        }
    }
}

