/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.sender;

import io.github.sashirestela.cleverclient.sender.HttpSender;
import io.github.sashirestela.cleverclient.support.CleverClientSSE;
import io.github.sashirestela.cleverclient.support.ReturnType;
import io.github.sashirestela.cleverclient.util.JsonUtil;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;

public class HttpAsyncStreamObjectSender
extends HttpSender {
    @Override
    public Object sendRequest(HttpClient httpClient, HttpRequest httpRequest, ReturnType returnType) {
        CompletableFuture<HttpResponse<Stream<String>>> httpResponseFuture = httpClient.sendAsync(httpRequest, HttpResponse.BodyHandlers.ofLines());
        return httpResponseFuture.thenApply(response -> {
            this.throwExceptionIfErrorIsPresent((HttpResponse<?>)response, Stream.class);
            CleverClientSSE.LineRecord lineRecord = new CleverClientSSE.LineRecord();
            Set<String> eventsWithHeader = returnType.getClassByEvent().keySet();
            return ((Stream)response.body()).map(line -> {
                logger.debug("Response : {}", line);
                lineRecord.updateWith((String)line);
                return new CleverClientSSE(lineRecord, eventsWithHeader);
            }).filter(CleverClientSSE::isActualData).map(item -> JsonUtil.jsonToObject(item.getActualData(), returnType.getClassByEvent().get(item.getMatchedEvent())));
        });
    }
}

