/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.support;

import io.github.sashirestela.cleverclient.support.CleverClientException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class Configurator {
    private static final String EVENT_HEADER = "event: ";
    private static final String SEPARATOR = "";
    private static Configurator configurator = new Configurator();
    private List<String> eventsToRead;
    private List<String> endsOfStream;
    private List<String> linesToCheck;
    private boolean wasBuilt = false;

    private Configurator() {
    }

    public Configurator(List<String> eventsToRead, List<String> endsOfStream) {
        if (Configurator.configurator.wasBuilt) {
            return;
        }
        Configurator.configurator.eventsToRead = eventsToRead;
        Configurator.configurator.endsOfStream = endsOfStream;
        Configurator.configurator.wasBuilt = true;
    }

    public static Configurator one() {
        if (!Configurator.configurator.wasBuilt) {
            throw new CleverClientException("You have to call Configurator.builder() first.");
        }
        return configurator;
    }

    public List<String> getLinesToCheck() {
        if (this.linesToCheck == null) {
            this.linesToCheck = this.eventsToRead.stream().filter(etr -> !etr.isEmpty()).map(etr -> EVENT_HEADER + etr).collect(Collectors.toList());
            this.linesToCheck.add(SEPARATOR);
        }
        return this.linesToCheck;
    }

    public static ConfiguratorBuilder builder() {
        return new ConfiguratorBuilder();
    }

    public List<String> getEventsToRead() {
        return this.eventsToRead;
    }

    public List<String> getEndsOfStream() {
        return this.endsOfStream;
    }

    public static class ConfiguratorBuilder {
        private ArrayList<String> eventsToRead;
        private ArrayList<String> endsOfStream;

        ConfiguratorBuilder() {
        }

        public ConfiguratorBuilder eventToRead(String eventToRead) {
            if (this.eventsToRead == null) {
                this.eventsToRead = new ArrayList();
            }
            this.eventsToRead.add(eventToRead);
            return this;
        }

        public ConfiguratorBuilder eventsToRead(Collection<? extends String> eventsToRead) {
            if (eventsToRead == null) {
                throw new NullPointerException("eventsToRead cannot be null");
            }
            if (this.eventsToRead == null) {
                this.eventsToRead = new ArrayList();
            }
            this.eventsToRead.addAll(eventsToRead);
            return this;
        }

        public ConfiguratorBuilder clearEventsToRead() {
            if (this.eventsToRead != null) {
                this.eventsToRead.clear();
            }
            return this;
        }

        public ConfiguratorBuilder endOfStream(String endOfStream) {
            if (this.endsOfStream == null) {
                this.endsOfStream = new ArrayList();
            }
            this.endsOfStream.add(endOfStream);
            return this;
        }

        public ConfiguratorBuilder endsOfStream(Collection<? extends String> endsOfStream) {
            if (endsOfStream == null) {
                throw new NullPointerException("endsOfStream cannot be null");
            }
            if (this.endsOfStream == null) {
                this.endsOfStream = new ArrayList();
            }
            this.endsOfStream.addAll(endsOfStream);
            return this;
        }

        public ConfiguratorBuilder clearEndsOfStream() {
            if (this.endsOfStream != null) {
                this.endsOfStream.clear();
            }
            return this;
        }

        public Configurator build() {
            List<String> endsOfStream;
            List<String> eventsToRead;
            switch (this.eventsToRead == null ? 0 : this.eventsToRead.size()) {
                case 0: {
                    eventsToRead = Collections.emptyList();
                    break;
                }
                case 1: {
                    eventsToRead = Collections.singletonList(this.eventsToRead.get(0));
                    break;
                }
                default: {
                    eventsToRead = Collections.unmodifiableList(new ArrayList<String>(this.eventsToRead));
                }
            }
            switch (this.endsOfStream == null ? 0 : this.endsOfStream.size()) {
                case 0: {
                    endsOfStream = Collections.emptyList();
                    break;
                }
                case 1: {
                    endsOfStream = Collections.singletonList(this.endsOfStream.get(0));
                    break;
                }
                default: {
                    endsOfStream = Collections.unmodifiableList(new ArrayList<String>(this.endsOfStream));
                }
            }
            return new Configurator(eventsToRead, endsOfStream);
        }

        public String toString() {
            return "Configurator.ConfiguratorBuilder(eventsToRead=" + this.eventsToRead + ", endsOfStream=" + this.endsOfStream + ")";
        }
    }
}

