/*
 * Decompiled with CFR 0.152.
 */
package io.github.sashirestela.cleverclient.sender;

import io.github.sashirestela.cleverclient.sender.HttpAsyncBinarySender;
import io.github.sashirestela.cleverclient.sender.HttpAsyncGenericSender;
import io.github.sashirestela.cleverclient.sender.HttpAsyncListSender;
import io.github.sashirestela.cleverclient.sender.HttpAsyncObjectSender;
import io.github.sashirestela.cleverclient.sender.HttpAsyncPlainTextSender;
import io.github.sashirestela.cleverclient.sender.HttpAsyncStreamSender;
import io.github.sashirestela.cleverclient.sender.HttpSender;
import io.github.sashirestela.cleverclient.sender.HttpSyncBinarySender;
import io.github.sashirestela.cleverclient.sender.HttpSyncGenericSender;
import io.github.sashirestela.cleverclient.sender.HttpSyncListSender;
import io.github.sashirestela.cleverclient.sender.HttpSyncObjectSender;
import io.github.sashirestela.cleverclient.sender.HttpSyncPlainTextSender;
import io.github.sashirestela.cleverclient.sender.HttpSyncStreamSender;
import io.github.sashirestela.cleverclient.support.CleverClientException;
import io.github.sashirestela.cleverclient.support.ReturnType;
import java.util.EnumMap;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSenderFactory {
    private static Logger logger = LoggerFactory.getLogger(HttpSenderFactory.class);
    private static HttpSenderFactory factory = null;
    private EnumMap<ReturnType.Category, Supplier<HttpSender>> sendersMap = new EnumMap(ReturnType.Category.class);

    private HttpSenderFactory() {
        this.sendersMap.put(ReturnType.Category.ASYNC_STREAM, HttpAsyncStreamSender::new);
        this.sendersMap.put(ReturnType.Category.ASYNC_LIST, HttpAsyncListSender::new);
        this.sendersMap.put(ReturnType.Category.ASYNC_GENERIC, HttpAsyncGenericSender::new);
        this.sendersMap.put(ReturnType.Category.ASYNC_OBJECT, HttpAsyncObjectSender::new);
        this.sendersMap.put(ReturnType.Category.ASYNC_BINARY, HttpAsyncBinarySender::new);
        this.sendersMap.put(ReturnType.Category.ASYNC_PLAIN_TEXT, HttpAsyncPlainTextSender::new);
        this.sendersMap.put(ReturnType.Category.SYNC_STREAM, HttpSyncStreamSender::new);
        this.sendersMap.put(ReturnType.Category.SYNC_LIST, HttpSyncListSender::new);
        this.sendersMap.put(ReturnType.Category.SYNC_GENERIC, HttpSyncGenericSender::new);
        this.sendersMap.put(ReturnType.Category.SYNC_OBJECT, HttpSyncObjectSender::new);
        this.sendersMap.put(ReturnType.Category.SYNC_BINARY, HttpSyncBinarySender::new);
        this.sendersMap.put(ReturnType.Category.SYNC_PLAIN_TEXT, HttpSyncPlainTextSender::new);
    }

    public static HttpSenderFactory get() {
        if (factory == null) {
            factory = new HttpSenderFactory();
        }
        return factory;
    }

    public HttpSender createSender(ReturnType returnType) {
        HttpSender sender = null;
        ReturnType.Category category = returnType.category();
        if (category == null || !this.sendersMap.containsKey((Object)category)) {
            throw new CleverClientException("Unsupported return type {0}.", returnType.getFullClassName(), null);
        }
        sender = this.sendersMap.get((Object)category).get();
        logger.debug("Created Sender : {}", (Object)sender.getClass().getSimpleName());
        return sender;
    }
}

